% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.summary.R
\name{trakt.movie.summary}
\alias{trakt.movie.summary}
\title{Get a single movie's details}
\usage{
trakt.movie.summary(target, extended = "min", force_data_frame = FALSE)
}
\arguments{
\item{target}{The \code{id} of the show requested. Either the \code{slug}
(e.g. \code{"game-of-thrones"}), \code{trakt id} or \code{IMDb id}. If multiple targets are
supplied, the results will be \code{rbind}ed together, automatically setting \code{force_data_frame}
to \code{TRUE}.}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"min"}, can either be \code{"min"} or \code{"full"}}

\item{force_data_frame}{If \code{TRUE}, the \code{list} is unnested as much as possible, resulting
in a flat \code{data.frame} suitable to be \code{rbind}ed to other summary results.}
}
\value{
A \code{list} or \code{data.frame} containing movie information
}
\description{
\code{trakt.movie.summary} returns a single movie's summary information.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/movies/summary/get-a-movie}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
trakt.movie.summary("tron-legacy-2010")
}
}
\seealso{
Other movie data: \code{\link{trakt.movie.people}};
  \code{\link{trakt.movie.ratings}};
  \code{\link{trakt.movie.releases}};
  \code{\link{trakt.movie.watching}};
  \code{\link{trakt.movies.popular}};
  \code{\link{trakt.movies.related}};
  \code{\link{trakt.movies.trending}};
  \code{\link{trakt.stats}}
}

