% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.show.related.R
\name{trakt.show.related}
\alias{trakt.show.related}
\title{Search for related shows}
\usage{
trakt.show.related(target)
}
\arguments{
\item{target}{The show's \code{slug} to be used.}
}
\value{
A \code{data.frame} containing search results
}
\description{
\code{trakt.show.related} returns shows related to the input show.
}
\details{
Receive a set of shows that are related to a specific show.
}
\note{
See \href{http://docs.trakt.apiary.io/#reference/shows/related/get-related-shows}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
related <- trakt.show.related("game-of-thrones")
}
}
\seealso{
Other show: \code{\link{trakt.getEpisodeData}};
  \code{\link{trakt.getFullShowData}};
  \code{\link{trakt.getSeasons}};
  \code{\link{trakt.show.people}};
  \code{\link{trakt.show.season}};
  \code{\link{trakt.show.stats}};
  \code{\link{trakt.show.summary}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.trending}}
}

