% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateTEF.R
\name{simulateTEF}
\alias{simulateTEF}
\title{Simulate trophic enrichment factors}
\usage{
simulateTEF(
  nN = 56,
  meanN = NULL,
  sdN = 0.98,
  nC = 107,
  meanC = NULL,
  sdC = 1.3
)
}
\arguments{
\item{nN}{number of observations for deltaN.}

\item{meanN}{mean for deltaN.}

\item{sdN}{standard deviation for deltaN.}

\item{nC}{number of observations for deltaC.}

\item{meanC}{mean for deltaC.}

\item{sdC}{standard deviation for deltaC.}
}
\value{
a named list with TEF values for nitrogen and/or carbon
}
\description{
This function returns trophic enrichment factors (TEF), given a number of
observations, a mean and a standard deviation for deltaN and/or deltaC. This
function has been replaced by simulateTDF, following the convention of naming
trophic discrimination factors (TDF) instead of trophic enrichment factors
(TEF).
}
\examples{
#simulateTEF() is deprecated, use simulateTDF() instead:

# 25 values of TEF for nitrogen, mean 3, sd, 1
simulateTDF(nN = 25, meanN = 3, sdN = 1)

# 18 values of TEF for carbon, mean 0.6, sd, 0.7
simulateTDF(nC = 18, meanC = 0.6, sdC = 0.7)

}
