% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtables.R
\name{gtable_extra}
\alias{gtable_extra}
\title{Grob underlying graphical display of a table with grobs of varying scales and colours.}
\usage{
gtable_extra(
  dscale,
  dcolor = NULL,
  dscale_min = NULL,
  dscale_max = NULL,
  rows = rownames(dscale),
  cols = colnames(dscale),
  rows_more = NULL,
  cols_more = NULL,
  theme = ttheme_awesome(),
  vp = NULL
)
}
\arguments{
\item{dscale}{a matrix containing the values defining the grobs scales.}

\item{dcolor}{(optional) a matrix of size (n,m) containing the values defining the grobs colors.}

\item{dscale_min}{(optional) value for setting the minimum scale size of foreground grobs. Entries in the
\code{dscale} matrix below \code{dscale_min} will have a scale of 0 (no grob).}

\item{dscale_max}{(optional) value for setting the maximum scale size of foreground grobs. Entries in the
\code{dscale} matrix above \code{dscale_max} will have a scale of 1.}

\item{rows}{(optional) a character vector.}

\item{cols}{(optional) a character vector.}

\item{rows_more}{(optional) a named list of additional columns (right-part) of the plot for describing the rows. The
list names will be used as column headers.}

\item{cols_more}{(optional) a named list of additional rows (top-part) of the plot for describing the columns The
list names will be used as row headers.}

\item{theme}{a list of theme parameters. Use an instance of \code{ttheme_awesome}.}

\item{vp}{optional viewport.}
}
\value{
A \code{gtable} object.
}
\description{
The code is inspired by the \code{tableGrob} function \code{gridExtra}.
}
\seealso{
\code{\link[=ttheme_awesome]{ttheme_awesome()}}
}
\author{
Yoann Pradat
}
