% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_html.R
\name{replace_html}
\alias{replace_html}
\title{Replaces a tableHTML string with another}
\usage{
replace_html(tableHTML, pattern, replacement, replace_all = FALSE, ...)
}
\arguments{
\item{tableHTML}{A tableHTML object created by the tableHTML function.}

\item{pattern}{A tableHTML string to be replaced. Regex is allowed.}

\item{replacement}{A replacement for the matched pattern.}

\item{replace_all}{TRUE or FALSE. If TRUE gsub is used internally and all the pattern occurrances
will be replaced. If FALSE sub is used internally and only the first occurance will be
replaced. Defaults to FALSE.}

\item{...}{Additional arguments passed on to sub or gsub.}
}
\value{
A tableHTML object.
}
\description{
\code{replace_html} replaces a tableHTML string with another
}
\details{
\code{replace_html} replaces a tableHTML string with another. The function calls sub and gsub
  internally (according to the replace_all argument) to do the replacements but in a safe way in 
  order to preserve the class of the tableHTML object. Also, \code{replace_html} has been 
  developed so that it can be used with chaining (using the pipe operator \%>\%). 
  See the examples to understand exactly how.
}
\examples{
a <- mtcars \%>\% 
  tableHTML() \%>\% 
  add_css_row(css = list('background-color', 'lightblue'), rows = 1)
    
a \%>\% 
  replace_html('lightblue', 'green')


}
\seealso{
\code{\link{gsub}} or \code{\link{sub}}
}

