% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\docType{class}
\name{Table}
\alias{Table}
\title{Table Class}
\format{\code{\link{R6Class}} object.}
\usage{
# Table.load(source, schema = NULL, strict = FALSE, headers = 1, ...)
}
\value{
Object of \code{\link{R6Class}} .
}
\description{
Table class for working with data and schema.
}
\section{Methods}{


\describe{

\item{\code{Table$new(source, schema, strict, headers)}}{
Use \code{\link{Table.load}} to instantiate \code{Table} class.}

\item{\code{iter(keyed, extended, cast=TRUE, relations=FALSE, stream=FALSE)}}{
  Iter through the table data and emits rows cast based on table schema. Data casting could be disabled.}
\itemize{
 \item{\code{keyed }}{Iter keyed rows - \code{TRUE}/\code{FALSE}}  
 \item{\code{extended }}{Iter extended rows - \code{TRUE}/\code{FALSE}}
 \item{\code{cast }}{Disable data casting if \code{FALSE}}
 \item{\code{relations }}{List object of foreign key references from a form of JSON \code{{resource1: [{field1: value1, field2: value2},...],...}}.
 If provided foreign key fields will checked and resolved to its references}
 \item{\code{stream }}{Return Readable Stream of table rows if \code{TRUE}}
 }
 
 
 \item{\code{read(keyed, extended, cast=TRUE, relations=FALSE, limit)}}{
  Read the whole table and returns as array of rows. Count of rows could be limited.}
\itemize{
 \item{\code{keyed }}{Flag to emit keyed rows - \code{TRUE}/\code{FALSE}}  
 \item{\code{extended }}{Flag to emit extended rows - \code{TRUE}/\code{FALSE}}
 \item{\code{cast }}{Disable data casting if \code{FALSE}}
 \item{\code{relations }}{List object of foreign key references from a form of JSON \code{{resource1: [{field1: value1, field2: value2},...],...}}.
 If provided foreign key fields will checked and resolved to its references}
 \item{\code{limit }}{Integer limit of rows to return if specified}
 }


\item{\code{infer(limit=100)}}{
  Infer a schema for the table. It will infer and set \code{Table Schema} to \code{table$schema} based on table data.}
\itemize{
 \item{\code{limit }}{Limit rows samle size - number}
 }
 
 
\item{\code{save(target)}}{
  Save data source to file locally in CSV format with \code{,} (comma) delimiter.}
\itemize{
 \item{\code{target }}{String path where to save a table data}
 }
}
}

\section{Properties}{

\describe{
  \item{\code{headers}}{Returns data source headers}
  \item{\code{schema}}{Returns schema class instance}
}
}

\section{Details}{


A table is a core concept in a tabular data world. It represents a data with a metadata (Table Schema).
Tabular data consists of a set of rows. Each row has a set of fields (columns). 
We usually expect that each row has the same set of fields and thus we can talk about the 
fields for the table as a whole. In case of tables in spreadsheets or CSV files we often interpret 
the first row as a header row, giving the names of the fields. By contrast, in other situations, 
e.g. tables in SQL databases, the field names are explicitly designated.


In order to talk about the representation and processing of tabular data from text-based sources, 
it is useful to introduce the concepts of the \emph{physical} and the \emph{logical} representation of data.

The \emph{physical representation} of data refers to the representation of data as text on disk, 
for example, in a CSV or JSON file. This representation may have some type information 
(JSON, where the primitive types that JSON supports can be used) or not 
(CSV, where all data is represented in string form).

The \emph{logical representation} of data refers to the "ideal" representation of the data 
in terms of primitive types, data structures, and relations, all as defined by the specification. 
We could say that the specification is about the logical representation of data, 
as well as about ways in which to handle conversion of a physical representation to a logical one.

We'll explicitly refer to either the \emph{physical} or \emph{logical} representation 
in places where it prevents ambiguity for those engaging with the specification, especially implementors.

For example, \code{constraints} should be tested on the logical representation of data, 
whereas a property like \code{missingValues} applies to the physical representation of the data.


\href{https://CRAN.R-project.org/package=jsonlite}{Jsolite package} is internally used to convert json data to list objects. The input parameters of functions could be json strings, 
files or lists and the outputs are in list format to easily further process your data in R environment and exported as desired. 
More details about handling json you can see jsonlite documentation or vignettes \href{https://CRAN.R-project.org/package=jsonlite}{here}.

\href{https://CRAN.R-project.org/package=future}{Future package} is also used to load and create Table and Schema class asynchronously. 
To retrieve the actual result of the loaded Table or Schema you have to call \code{value(future)} to the variable you stored the loaded Table/Schema. 
More details about future package and sequential and parallel processing you can find \href{https://CRAN.R-project.org/package=future}{here}.

Examples section of each function show how to use jsonlite and future packages with tableschema.r.
}

\section{Language}{

The key words \code{MUST}, \code{MUST NOT}, \code{REQUIRED}, \code{SHALL}, \code{SHALL NOT}, 
\code{SHOULD}, \code{SHOULD NOT}, \code{RECOMMENDED}, \code{MAY}, and \code{OPTIONAL} 
in this package documents are to be interpreted as described in \href{https://www.ietf.org/rfc/rfc2119.txt}{RFC 2119}.
}

\seealso{
\code{\link{Table.load}}, 
\href{http://frictionlessdata.io/specs/table-schema/}{Table Schema Specifications}
}
\keyword{data}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Table$new()}}
\item \href{#method-infer}{\code{Table$infer()}}
\item \href{#method-iter}{\code{Table$iter()}}
\item \href{#method-read}{\code{Table$read()}}
\item \href{#method-save}{\code{Table$save()}}
\item \href{#method-clone}{\code{Table$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Table$new(src, schema = NULL, strict = FALSE, headers = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{schema}}{data schema in all forms supported by \code{Schema} class}

\item{\code{strict}}{strictness option \code{TRUE} or \code{FALSE}, to pass to \code{Schema} constructor}

\item{\code{headers}}{data source headers, one of:
\itemize{
 \item row number containing headers (\code{source} should contain headers rows)
 \item list of headers (\code{source} should NOT contain headers rows)
 }}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-infer"></a>}}
\subsection{Method \code{infer()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Table$infer(limit = 100)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-iter"></a>}}
\subsection{Method \code{iter()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Table$iter(keyed, extended, cast = TRUE, relations = FALSE, stream = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-read"></a>}}
\subsection{Method \code{read()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Table$read(
  keyed = FALSE,
  extended = FALSE,
  cast = TRUE,
  relations = FALSE,
  limit = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save"></a>}}
\subsection{Method \code{save()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Table$save(connection)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Table$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
