% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\docType{class}
\name{Types}
\alias{Types}
\title{Types class}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} .
}
\description{
R6 class with Types and Formats.

\code{type} and \code{format} properties are used to give the type of the field (string, number etc) - 
see \href{https://specs.frictionlessdata.io//table-schema/#types-and-formats}{types and formats} for more details. 
If type is not provided a consumer should assume a type of "string".

A field's \code{type} property is a string indicating the type of this field.

A field's \code{format} property is a string, indicating a format for the field type.

Both \code{type} and format are optional: in a field descriptor, the absence of a \code{type} property indicates that 
the field is of the type "string", and the absence of a \code{format} property indicates that the field's type \code{format} is "default".

Types are based on the \href{https://datatracker.ietf.org/doc/html/draft-zyp-json-schema-03#section-5.1}{type set of json-schema} 
with some additions and minor modifications (cf other type lists include those in 
\href{http://www.elasticsearch.org/guide/reference/mapping/}{Elasticsearch types}).
}
\section{Fields}{

\describe{
\item{\code{casts}}{see Section See also}
}}

\seealso{
\href{https://specs.frictionlessdata.io//table-schema/#types-and-formats}{Types and formats specifications},
\code{\link{types.castAny}},
\code{\link{types.castBoolean}},
\code{\link{types.castDate}},
\code{\link{types.castDatetime}},
\code{\link{types.castDuration}},
\code{\link{types.castGeojson}},
\code{\link{types.castGeopoint}},
\code{\link{types.castInteger}},
\code{\link{types.castList}},
\code{\link{types.castNumber}},
\code{\link{types.castObject}},
\code{\link{types.castString}},
\code{\link{types.castTime}},
\code{\link{types.castYear}},
\code{\link{types.castYearmonth}},
\code{\link{types.castArray}}
}
\keyword{data}
