% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_methods.R
\name{tabr-rep}
\alias{tabr-rep}
\alias{rep.noteworthy}
\alias{rep.noteinfo}
\alias{rep.music}
\alias{rep.lyrics}
\alias{rep.phrase}
\title{Repeat for tabr classes}
\usage{
\method{rep}{noteworthy}(x, ...)

\method{rep}{noteinfo}(x, ...)

\method{rep}{music}(x, ...)

\method{rep}{lyrics}(x, ...)

\method{rep}{phrase}(x, ...)
}
\arguments{
\item{x}{object.}

\item{...}{additional arguments. Not accepted for phrase objects.}
}
\description{
Several methods are implemented for the classes \code{noteworthy}, \code{noteinfo}, and
\code{music}. See \code{\link[=tabr-methods]{tabr-methods()}} for more details on methods for tabr classes.
}
\examples{
# noteworthy class examples
x <- "a b c"
rep(x, 2)
rep(as_noteworthy(x), 2)

# noteinfo class examples
x <- "4x 4-.*2 2"
rep(as_noteinfo(x), times = c(2, 1, 1, 2))

# music class examples
x <- "c,~4 c,1 c'e_'g'4-."
rep(as_music(x), each = 2)

# phrase class examples
rep(phrase(x), 2)
}
\seealso{
\code{\link[=tabr-methods]{tabr-methods()}}, \code{\link[=note-metadata]{note-metadata()}}
}
