% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noteinfo.R
\name{valid-noteinfo}
\alias{valid-noteinfo}
\alias{informable}
\alias{as_noteinfo}
\alias{is_noteinfo}
\title{Check note info validity}
\usage{
informable(x, na.rm = FALSE)

as_noteinfo(x, format = NULL)

is_noteinfo(x)
}
\arguments{
\item{x}{character, a note info string.}

\item{na.rm}{remove \code{NA}s.}

\item{format}{\code{NULL} or character, the timestep delimiter format, \code{"space"}
or \code{"vector"}.}
}
\value{
depends on the function
}
\description{
Check whether a note info string is comprised exclusively of valid note info
syntax.
\code{noteinfo} returns a scalar logical result indicating whether the entire set
contains exclusively valid entries.
}
\details{
\code{as_noteinfo()} can be used to coerce to the \code{noteinfo} class.
Coercion will fail if the string is has any syntax that is not valid for
note info.
Using the \code{noteinfo} class is generally not needed by the user during
an interactive session, but is available and offers its own \code{print()} and
\code{summary()} methods for note info strings.
The class is often used by other functions, and functions that output a
note info string attach the \code{noteinfo} class.

When \code{format = NULL}, the timestep delimiter format is inferred from the note
info string input. When unclear, such as with phrase objects, the default is
space-delimited time.
}
\examples{
a <- notate("8x", "Start here")
x <- paste(a, "8[stacatto] 8-. 16 4.. 16- 16 2^ 2 4. 8( 4)( 4) 8*4 1 1")

informable(x) # is it of 'noteinfo' class; a validity check for any string
x <- as_noteinfo(x) # coerce to 'noteinfo' class
is_noteinfo(x) # check for 'noteinfo' class
x

summary(x)
}
\seealso{
\code{\link[=noteinfo]{noteinfo()}}, \code{\link[=valid-notes]{valid-notes()}}
}
