% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_correction.R
\name{get_correction}
\alias{get_correction}
\title{Get and prepare correction}
\usage{
get_correction(
  correction = NULL,
  topo = NULL,
  curve = NULL,
  units = list(topo = "m", curve = c(names = "yr", value = "m"), correction = "mm/yr"),
  verbose = FALSE
)
}
\arguments{
\item{correction}{SpatRaster. Correction value, vector, grid, or list of grids to account for spatial-(non-)explicit and temporal (non-)linear changes in the topography (e.g., uplift and subsidence rates, sedimentation and erosion ticknesses)}

\item{topo}{SpatRaster. Topographic/Bathymetric model as SpatRaster or path to dataset. The topo projection is the reference for further outputs.}

\item{curve}{SpatRaster. Curve value, vector, grid or list of grids indicating the relative altitude of a biogeographic system per time period compared to the present. A typical example is a sea level curve indicating the relative sea level position above or below sea level compared to the present.}

\item{units}{numeric. Units of topo, curve and correction provided as a list (default: units=list(topo='m', curve=c(names='yr', value='m'), correction='mm/yr'))}

\item{verbose}{boolean. FALSE: No messages are printed. TRUE: Standard verbose mode 2: Very verbose mode, displaying detailed information.}
}
\value{
A SpatRaster or vector with corrrection values in a suitable format for the reconstruct function, including a value for each time step, defined by the curve.
}
\description{
Get and prepare a correction dataset
}
\examples{

sporades <- sporades()
topo <- sporades$topo
correction <- sporades$correction
curve <- sporades$curve

cor <- get_correction(correction=correction,
                      topo=topo,
                      curve=curve)

}
\seealso{
\href{https://uva_ibed_piac.gitlab.io/tabs/articles/Bb-tabs-correction.html}{correction}
}
\author{
Johannes De Groeve
}
