% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_spot.R
\docType{methods}
\name{plot_spot}
\alias{plot_spot}
\alias{plot_spot-method}
\alias{plot_spot,matrix-method}
\alias{plot_spot,data.frame-method}
\alias{plot_spot,dist-method}
\title{Spot Plot}
\usage{
plot_spot(object, ...)

\S4method{plot_spot}{matrix}(
  object,
  type = c("ring", "plain"),
  col = grDevices::hcl.colors(12, "YlOrBr", rev = TRUE),
  diag = TRUE,
  upper = TRUE,
  lower = TRUE,
  freq = FALSE,
  margin = 1,
  axes = TRUE,
  legend = TRUE,
  ...
)

\S4method{plot_spot}{data.frame}(
  object,
  type = c("ring", "plain"),
  col = grDevices::hcl.colors(12, "YlOrBr", rev = TRUE),
  diag = TRUE,
  upper = TRUE,
  lower = TRUE,
  freq = FALSE,
  margin = 1,
  axes = TRUE,
  legend = TRUE,
  ...
)

\S4method{plot_spot}{dist}(
  object,
  type = c("ring", "plain"),
  col = grDevices::hcl.colors(12, "YlOrBr", rev = TRUE),
  diag = FALSE,
  upper = FALSE,
  lower = !upper,
  axes = TRUE,
  legend = TRUE,
  ...
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table).}

\item{...}{Currently not used.}

\item{type}{A \code{\link{character}} string specifying the graph to be plotted.
It must be one of "\code{ring}" (the default) or "\code{plain}". Any unambiguous
substring can be given.}

\item{col}{A vector of colors.}

\item{diag}{A \code{\link{logical}} scalar indicating whether the diagonal of the
matrix should be plotted. Only used if \code{object} is a symmetric matrix.}

\item{upper}{A \code{\link{logical}} scalar indicating whether the upper triangle of
the matrix should be plotted. Only used if \code{object} is a symmetric matrix.}

\item{lower}{A \code{\link{logical}} scalar indicating whether the lower triangle of
the matrix should be plotted. Only used if \code{object} is a symmetric matrix.}

\item{freq}{A \code{\link{logical}} scalar indicating whether conditional proportions
given \code{margins} should be used (i.e. entries of \code{object}, divided by the
appropriate marginal sums).}

\item{margin}{An \code{\link{integer}} vector giving the margins to split by:
\code{1} indicates individuals/rows (the default), \code{2} indicates
variables/columns. Only used if \code{freq} is \code{TRUE}.}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot? It will
omit labels where they would abut or overlap previously drawn labels.}

\item{legend}{A \code{\link{logical}} scalar: should a legend be displayed?}
}
\value{
\code{plot_spot()} is called it for its side-effects: it results in a graphic
being displayed (invisibly returns \code{object}).
}
\description{
Plots a spot matrix.
}
\details{
The spot matrix can be considered as a variant of the
\link[=plot_bertin]{Bertin diagram} where the data are first transformed to
relative frequencies.
}
\note{
Adapted from Dan Gopstein's original
\href{https://dgopstein.github.io/articles/spot-matrix/}{idea}.
}
\examples{
## Data from Huntley 2004, 2008
data("pueblo")

## Plot spot diagram of count data
plot_spot(pueblo, type = "ring")
plot_spot(pueblo, type = "plain")

## Plot conditional proportions
plot_spot(pueblo, freq = TRUE, margin = 1)
plot_spot(pueblo, freq = TRUE, margin = 2)
}
\seealso{
Other plot methods: 
\code{\link{matrigraph}()},
\code{\link{plot_bertin}()},
\code{\link{plot_diceleraas}()},
\code{\link{plot_diversity}},
\code{\link{plot_ford}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_rank}()},
\code{\link{plot_rarefaction}},
\code{\link{seriograph}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
