% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity.R
\docType{methods}
\name{turnover}
\alias{turnover}
\alias{turnover-method}
\alias{turnover,matrix-method}
\alias{turnover,data.frame-method}
\title{Turnover}
\usage{
turnover(object, ...)

\S4method{turnover}{matrix}(
  object,
  ...,
  method = c("whittaker", "cody", "routledge1", "routledge2", "routledge3", "wilson")
)

\S4method{turnover}{data.frame}(
  object,
  ...,
  method = c("whittaker", "cody", "routledge1", "routledge2", "routledge3", "wilson")
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data or incidence data. A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{...}{Further arguments to be passed to internal methods.}

\item{method}{A \code{\link{character}} string specifying the method to be
used (see details). Any unambiguous substring can be given.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Returns the degree of turnover in taxa composition along a gradient or
transect.
}
\details{
The following methods can be used to ascertain the degree of \emph{turnover}
in taxa composition along a gradient (\eqn{\beta}-diversity) on qualitative
(presence/absence) data:

\describe{
\item{\code{cody}}{\link[=index_cody]{Cody measure}.}
\item{\code{routledge1}}{\link[=index_routledge]{Routledge first measure}.}
\item{\code{routledge2}}{\link[=index_routledge]{Routledge second measure}.}
\item{\code{routledge3}}{\link[=index_routledge]{Routledge third measure} (exponential
form of the second measure).}
\item{\code{whittaker}}{\link[=index_whittaker]{Whittaker measure}.}
\item{\code{wilson}}{\link[=index_wilson]{Wilson measure}.}
}

This assumes that the order of the matrix rows (from \eqn{1} to \eqn{n})
follows the progression along the gradient/transect.
}
\examples{
## Data from Magurran 1988, p. 162
data("woodland")

## Whittaker's measure
turnover(woodland, "whittaker") # 1

## Cody's measure
turnover(woodland, "cody") # 3

## Routledge's measures
turnover(woodland, "routledge1") # 0.29
turnover(woodland, "routledge2") # 0.56
turnover(woodland, "routledge3") # 1.75

## Wilson and Shmida's measure
turnover(woodland, "wilson") # 1
}
\seealso{
\code{\link[=index_cody]{index_cody()}}, \code{\link[=index_routledge1]{index_routledge1()}}, \code{\link[=index_routledge2]{index_routledge2()}},
\code{\link[=index_routledge3]{index_routledge3()}}, \code{\link[=index_whittaker]{index_whittaker()}}, \code{\link[=index_wilson]{index_wilson()}}

Other diversity measures: 
\code{\link{heterogeneity}()},
\code{\link{occurrence}()},
\code{\link{profiles}()},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{she}()},
\code{\link{similarity}()},
\code{\link{simulate}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
