% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanup_helpers.R
\name{delete_na}
\alias{delete_na}
\title{Delete cases with set amount of missing values}
\usage{
delete_na(df, n = ncol(df) - 1)
}
\arguments{
\item{df}{A \code{data.frame},}

\item{n}{Number of \code{NAs} allowed, defaults to \code{ncol(df) - 1}.}
}
\value{
A filtered version of the input \code{data.frame}.
}
\description{
Delete cases with set amount of missing values
}
\note{
Adapted from http://stackoverflow.com/a/30461945/409362.
}
\examples{
set.seed(1445)
dat <- data.frame(
  x = sample(c(1:15, NA, NA), 15),
  y = sample(c(1:15, NA, NA), 15),
  z = sample(c(1:15, NA, NA), 15)
)
dat
# No NsA per row allowed
delete_na(dat, 0)
# One NA per row allowed
delete_na(dat, 1)
}
