% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_test.R
\name{z.test}
\alias{z.test}
\title{One- and Two-Sample z-Test}
\source{
\link[stats:t.test]{stats::t.test}
}
\usage{
z.test(
  x,
  y = NULL,
  alternative = c("two.sided", "less", "greater"),
  mu = 0,
  sigma_x,
  sigma_y = NULL,
  paired = FALSE,
  conf.level = 0.95
)
}
\arguments{
\item{x}{A (non-empty) numeric vector of data values}

\item{y}{An optional (non-empty) numeric vector of data values. If omitted, a one-sample
test is conducted.}

\item{alternative}{A character string specifying the alternative hypothesis, must be
one of "two.sided" (default), "greater" or "less". You can specify just the initial letter.}

\item{mu}{A number indicating the true value of the mean (or difference in means if
you are performing a two sample test).}

\item{sigma_x, sigma_y}{The assumed known variance of \code{x} and \code{y}. Must be numeric.}

\item{paired}{A logical indicating whether you want a paired t-test.}

\item{conf.level}{Confidence level of the interval.}
}
\value{
An object of class \code{htest}, see \link[stats:t.test]{stats::t.test}
}
\description{
Since the "standard" z-test is not available in R as in most real-world scenarios you're
only ever going to use a t-test, this function fills that gap for teaching purposes.
The function is basically a carbon-copy of \link[stats:t.test]{stats::t.test}, but with user-supplied
variances for x and y and p-value and related calculations use a standard normal distribution.
}
\examples{
x <- rnorm(10, 5, 1)
y <- 1:10 + rnorm(10, 3, 1.5)

# Two sample
z.test(x, y, sigma_x = 1, sigma_y = 1.5)

# One sample
z.test(x, sigma_x = 1, mu = 5)
}
