% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reinert.R
\name{reinPlot}
\alias{reinPlot}
\title{Plot Terms by Cluster}
\usage{
reinPlot(terms, nPlot = 10)
}
\arguments{
\item{terms}{A data frame containing terms and their associated statistics, such as Chi-squared values,
generated by the \code{term_per_cluster} function. The data frame must include the following columns:
\itemize{
\item \code{term}: The term to plot.
\item \code{chi_square}: The Chi-squared statistic associated with the term.
\item \code{sign}: The sign of the term (\code{"positive"} or \code{"negative"}).
}}

\item{nPlot}{Integer. The number of top terms to plot for each sign (\code{"positive"} and \code{"negative"}). Default is 10.}
}
\value{
An interactive horizontal bar plot (using \code{plotly}) displaying the top terms for each cluster. The plot includes:
\itemize{
\item Bars representing the Chi-squared values of terms.
\item Hover information displaying the term and its Chi-squared value.
}
}
\description{
This function creates a horizontal bar plot to visualize the most significant terms
for each cluster, based on their Chi-squared statistics.
}
\details{
The function organizes the input data by Chi-squared values and selects the top terms for each sign.
The plot uses different colors for positive and negative terms, with hover tooltips providing detailed information.
}
\examples{
\dontrun{
data(mobydick)
res <- reinert(
  x=mobydick,
  k = 10,
  term = "token",
  segment_size = 40,
  min_segment_size = 5,
  min_split_members = 10,
  cc_test = 0.3,
  tsj = 3
)

tc <- term_per_cluster(res, cutree = NULL, k=1, negative=FALSE)

fig <- reinPlot(tc$terms, nPlot = 10)
}

}
\seealso{
\code{\link{term_per_cluster}}
}
