% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{stems}
\alias{stems}
\title{Get stem taxa}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object containing taxon
information to be queried.}

\item{subset}{Taxon IDs, TRUE/FALSE vector, or taxon indexes to find stems for.
Default: All taxa in \code{obj} will be used. Any variable name that appears in
\code{\link[=all_names]{all_names()}} can be used as if it was a vector on its own.}

\item{value}{What data to return. This is usually the name of column in a
table in \code{obj$data}. Any result of \code{all_names(obj)} can be used, but it
usually only makes sense to data that corresponds to taxa 1:1, such as
\code{\link[=taxon_ranks]{taxon_ranks()}}. By default, taxon indexes are returned.}

\item{simplify}{(\code{logical}) If \code{TRUE}, then combine all the results
into a single vector of unique values.}

\item{exclude_leaves}{(\code{logical}) If \code{TRUE}, the do not include
taxa with no subtaxa.}
}
\value{
\code{character}
}
\description{
Return the stem taxa for a \code{\link[=taxonomy]{taxonomy()}} or a \code{\link[=taxmap]{taxmap()}}
object. Stem taxa are all those from the roots to the first taxon with more
than one subtaxon.
\preformatted{
obj$stems(subset = NULL, simplify = FALSE,
  value = "taxon_indexes", exclude_leaves = FALSE)
stems(obj, subset = NULL, simplify = FALSE,
  value = "taxon_indexes", exclude_leaves = FALSE)}
}
\examples{
# Return indexes of stem taxa
stems(ex_taxmap)

# Return indexes for a subset of taxa
stems(ex_taxmap, subset = 2:17)

# Return something besides taxon indexes
stems(ex_taxmap, value = "taxon_names")

# Return a vector instead of a list
stems(ex_taxmap, value = "taxon_names", simplify = TRUE)

}
\seealso{
Other taxonomy indexing functions: \code{\link{branches}},
  \code{\link{internodes}}, \code{\link{leaves}},
  \code{\link{roots}}, \code{\link{subtaxa}},
  \code{\link{supertaxa}}
}
\concept{taxonomy indexing functions}
