% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--printers.R
\name{print_item}
\alias{print_item}
\title{Print a item}
\usage{
print_item(
  obj,
  data,
  name = NULL,
  max_rows = 3,
  max_items = 3,
  max_width = getOption("width") - 10,
  prefix = ""
)
}
\arguments{
\item{obj}{The taxmap object containing the thing to print}

\item{data}{The item to be printed}

\item{max_rows}{(\code{numeric} of length 1) The maximum number of rows in
tables to print.}

\item{max_items}{(\code{numeric} of length 1) The maximum number of list
items to print.}

\item{max_width}{(\code{numeric} of length 1) The maximum number of
characters to print.}

\item{prefix}{(\code{numeric} of length 1) What to print in front of each
line.}
}
\description{
Used to print each item in the \code{taxmap} print method.
}
\examples{
taxa:::print_item(ex_taxmap, ex_taxmap$data$info)
taxa:::print_item(ex_taxmap, 1:100)

}
\keyword{internal}
