% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa_tbl.R
\name{taxa_tbl}
\alias{taxa_tbl}
\title{Return a reference to a given table in the taxadb database}
\usage{
taxa_tbl(
  provider = getOption("taxadb_default_provider", "itis"),
  schema = c("dwc", "common"),
  version = latest_version(),
  db = td_connect()
)
}
\arguments{
\item{provider}{from which provider should the hierarchy be returned?
Default is 'itis', which can also be configured using \verb{options(default_taxadb_provider=...")}.
See \verb{[td_create]} for a list of recognized providers.}

\item{schema}{One of "dwc" (for Darwin Core data) or "common"
(for the Common names table.)}

\item{version}{Which version of the taxadb provider database should we use?
defaults to latest.  See \link{available_versions} for details.}

\item{db}{a connection to the taxadb database. See details.}
}
\description{
Return a reference to a given table in the taxadb database
}
\examples{
\donttest{
  \dontshow{
   ## All examples use a temporary directory
   Sys.setenv(TAXADB_HOME=tempdir())
  }

  #Clean a list of messy common names
  names <- clean_names(c("Steller's jay", "coopers Hawk"),
                binomial_only = FALSE, remove_sp = FALSE, remove_punc = TRUE)

  #Get cleaned common names from a provider and
  # search for cleaned names in that table
  taxa_tbl("itis", "common") \%>\%
  mutate_db(clean_names, "vernacularName", "vernacularNameClean",
            binomial_only = FALSE, remove_sp = FALSE, remove_punc = TRUE) \%>\%
  filter(vernacularNameClean \%in\% names)



}
}
