% Generated by roxygen2 (4.0.1): do not edit by hand
\name{gnr_datasources}
\alias{gnr_datasources}
\title{Get data sources for the Global Names Resolver.}
\usage{
gnr_datasources(todf = TRUE)
}
\arguments{
\item{todf}{logical; Should a data.frame be returned?}
}
\value{
json or a data.frame
}
\description{
Retrieve data sources used in Global Names Index, see
   \url{http://gni.globalnames.org/} for information.
}
\examples{
\donttest{
# all data sources
gnr_datasources()

# give me the id for EOL
out <- gnr_datasources()
out[out$title == "EOL", "id"]

# Fuzzy search for sources with the word zoo
out <- gnr_datasources()
out[agrep("zoo", out$title, ignore.case = TRUE), ]

# Output as a list
gnr_datasources(FALSE)
}
}
\author{
Scott Chamberlain {myrmecocystus@gmail.com}
}
\seealso{
\code{\link[taxize]{gnr_resolve}}
}
\keyword{names}
\keyword{resolve}
\keyword{taxonomy}

