% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/genbank2uid.R
\name{genbank2uid}
\alias{genbank2uid}
\title{Get NCBI taxonomy UID from GenBankID}
\usage{
genbank2uid(id, ...)
}
\arguments{
\item{id}{A GenBank accession alphanumeric string, or a gi numeric string.}

\item{...}{Curl args passed on to \code{\link[httr]{GET}}}
}
\description{
Get NCBI taxonomy UID from GenBankID
}
\details{
See \url{http://www.ncbi.nlm.nih.gov/Sitemap/sequenceIDs.html} for help on why
there are two identifiers, and the difference between them.
}
\examples{
\dontrun{
# with accession numbers
genbank2uid(id = 'AJ748748')
genbank2uid(id = 'Y13155')
genbank2uid(id = 'X78312')
genbank2uid(id = 'KM495596')

# with gi numbers
genbank2uid(id = 62689767)
genbank2uid(id = 22775511)
genbank2uid(id = 156446673)

# pass in many accession or gi numbers
genbank2uid(c(62689767,156446673))
genbank2uid(c('X78312','KM495596'))
genbank2uid(list('X78312',156446673))

# curl options
library('httr')
genbank2uid(id = 156446673, config=verbose())
}
}

