% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpl_get.r
\name{tpl_get}
\alias{tpl_get}
\title{Get The Plant List csv files.}
\usage{
tpl_get(x, family = NULL, ...)
}
\arguments{
\item{x}{Directory to write csv files to.}

\item{family}{If you want just one, or >1 family, but not all, list
them in a vector.}

\item{...}{(list) Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
Returns nothing to console, except a message and progress bar.
Writes csv files to x.
}
\description{
Get The Plant List csv files.
}
\details{
Throws a warning if you already have a directory of the one
provided, but still works. Writes to your home directory, change x
as needed.
}
\examples{
\dontrun{
# Get a few families
dir <- file.path(tempdir(), "abc")
tpl_get(dir, family = c("Platanaceae","Winteraceae"))

# You can now get Gymnosperms as well
dir1 <- file.path(tempdir(), "def")
tpl_get(dir1, family = c("Pinaceae","Taxaceae"))

# You can get mosses too!
dir2 <- file.path(tempdir(), "ghi")
tpl_get(dir2, family = "Echinodiaceae")

# Get all families
## Beware, will take a while
## dir3 <- file.path(tempdir(), "jkl")
## tpl_get("dir3)
}
}
\references{
The Plant List http://www.theplantlist.org
}
\seealso{
\code{\link{tpl_families}}
}
\author{
John Baumgartner (johnbb@student.unimelb.edu.au)
}
