% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tolid.R
\name{get_tolid}
\alias{get_tolid}
\alias{as.tolid}
\alias{as.tolid.tolid}
\alias{as.tolid.character}
\alias{as.tolid.list}
\alias{as.tolid.numeric}
\alias{as.tolid.data.frame}
\alias{as.data.frame.tolid}
\alias{get_tolid_}
\title{Get the OTT id for a search term}
\usage{
get_tolid(sciname, ask = TRUE, messages = TRUE, rows = NA, ...)

as.tolid(x, check = TRUE)

\method{as.tolid}{tolid}(x, check = TRUE)

\method{as.tolid}{character}(x, check = TRUE)

\method{as.tolid}{list}(x, check = TRUE)

\method{as.tolid}{numeric}(x, check = TRUE)

\method{as.tolid}{data.frame}(x, check = TRUE)

\method{as.data.frame}{tolid}(x, ...)

get_tolid_(sciname, messages = TRUE, rows = NA)
}
\arguments{
\item{sciname}{character; scientific name. Or, a \code{taxon_state}
object (see \link{taxon-state})}

\item{ask}{logical; should \code{get_tolid} be run in interactive mode?
If \code{TRUE} and more than one TOL is found for the species, the user is
asked for input. If \code{FALSE} NA is returned for multiple matches.}

\item{messages}{logical; should progress be printed?}

\item{rows}{numeric; Any number from 1 to infinity. If the default NA, all
rows are considered. Note that this function still only gives back a tol
class object with one to many identifiers. See \code{\link[=get_tolid_]{get_tolid_()}}
to get back all, or a subset, of the raw data that you are presented during
the ask process.}

\item{...}{Ignored}

\item{x}{Input to \code{as.tolid}}

\item{check}{logical; Check if ID matches any existing on the DB, only
used in \code{\link[=as.tolid]{as.tolid()}}}
}
\value{
A vector of taxonomic identifiers as an S3 class.
If a taxon is not found an \code{NA} is given. If more than one identifier
is found the function asks for user input if \code{ask = TRUE}, otherwise
returns \code{NA}. If \code{ask=FALSE} and \code{rows} does not equal
\code{NA}, then a data.frame is given back, but not of the uid class, which
you can't pass on to other functions as you normally can.

See \code{\link{get_id_details}} for further details including
attributes and exceptions
}
\description{
Retrieve the Open Tree of Life Taxonomy (OTT) id of a taxon from
OpenTreeOfLife
}
\examples{
\dontrun{
get_tolid(sciname = "Quercus douglasii")
get_tolid(sciname = "Chironomus riparius")
get_tolid(c("Chironomus riparius","Quercus douglasii"))
splist <- c("annona cherimola", 'annona muricata', "quercus robur",
		"shorea robusta", "pandanus patina", "oryza sativa", "durio zibethinus")
get_tolid(splist, messages=FALSE)

# specify rows to limit choices available
get_tolid('Arni')
get_tolid('Arni', rows=1)
get_tolid('Arni', rows=1:2)

# When not found
get_tolid("howdy")
get_tolid(c("Chironomus riparius", "howdy"))

# Convert a tol without class information to a tol class
as.tolid(get_tolid("Quercus douglasii")) # already a tol, returns the same
as.tolid(get_tolid(c("Chironomus riparius","Pinus contorta"))) # same
as.tolid(3930798) # numeric
as.tolid(c(3930798,515712,872577)) # numeric vector, length > 1
as.tolid("3930798") # character
as.tolid(c("3930798","515712","872577")) # character vector, length > 1
as.tolid(list("3930798","515712","872577")) # list, either numeric or character
## dont check, much faster
as.tolid("3930798", check=FALSE)
as.tolid(3930798, check=FALSE)
as.tolid(c("3930798","515712","872577"), check=FALSE)
as.tolid(list("3930798","515712","872577"), check=FALSE)

(out <- as.tolid(c(3930798,515712,872577)))
data.frame(out)
as.tolid( data.frame(out) )

# Get all data back
get_tolid_(sciname="Arni")
get_tolid_("Arni", rows=1)
get_tolid_("Arni", rows=1:2)
get_tolid_(c("asdfadfasd","Pinus contorta"))
}
}
\seealso{
\code{\link[=classification]{classification()}}

Other taxonomic-ids: \code{\link{get_boldid}},
  \code{\link{get_colid}}, \code{\link{get_eolid}},
  \code{\link{get_gbifid}}, \code{\link{get_ids}},
  \code{\link{get_iucn}}, \code{\link{get_natservid}},
  \code{\link{get_nbnid}}, \code{\link{get_pow}},
  \code{\link{get_tpsid}}, \code{\link{get_tsn}},
  \code{\link{get_uid}}, \code{\link{get_wiki}},
  \code{\link{get_wormsid}}
}
\concept{taxonomic-ids}
