% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_methods.R
\name{prepare_comparable_rank_dist}
\alias{prepare_comparable_rank_dist}
\title{Get comparable NCBI and GBIF taxonomic ranks}
\usage{
prepare_comparable_rank_dist(x, GBIF = TRUE, NCBI = TRUE)
}
\arguments{
\item{x}{A tibble created with \code{load_taxonomies()} or \code{load_population()} or \code{load_sample()}.}

\item{GBIF}{A logical indicating whether GBIF taxonomic ranks are to be retrieved.}

\item{NCBI}{A logical indicating whether NCBI taxonomic ranks are to be retrieved.}
}
\value{
A list of tibble(s) assigned to the S3 class \code{one_rank} or to the S3 class \code{all_ranks}.
}
\description{
Get comparable NCBI and GBIF taxonomic ranks
}
\details{
This method, like \code{prepare_rank_dist()}, returns taxonomic ranks aggregated by frequency for
data derived from the NCBI, the GBIF, or both. However, this method only retains
taxonomic ranks that have at least one NCBI and one GBIF representative.
}
\examples{
prepare_comparable_rank_dist(load_sample())
prepare_comparable_rank_dist(get_status(load_sample(), "accepted"), NCBI = FALSE)
}
