% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compact_ids.R
\name{compact_ids}
\alias{compact_ids}
\title{compact id numbers}
\usage{
compact_ids(dat, id = "id", accid = "accid", startid = 1, verbose = TRUE)
}
\arguments{
\item{dat}{taxonomic list in a data frame with id and accid columns}

\item{id}{column name for 'id'. Default 'id'}

\item{accid}{column name for 'accid'. Default 'accid'}

\item{startid}{starting id number for the list. Default 1}

\item{verbose}{verbose output on the console}
}
\value{
returns data frame
}
\description{
Compacting and converting the id values to numeric if required
to make sure dependent functions work well
}
\details{
Helper function to make sure values for ids are in right format and
are compact
}
\examples{
\donttest{
mylist <- data.frame("id" = c("1","2","3","4","5"),
                     "canonical" = c("Hypochlorosis ancharia",
                                     "Pseudonotis humboldti",
                                     "Myrina ancharia",
                                     "Hypochlorosis ancharia obiana",
                                     "Hypochlorosis lorquinii"),
                     "family" = c("Lycaenidae", "Lycaenidae", 
                                  "Lycaenidae", "Lycaenidae",
                                  "Lycaenidae"),
                     "accid" = c("0","1","1","0","0"),
                     "source" = c("itis","wiki","wiki","itis",
                                  "itis"),
                     stringsAsFactors = FALSE)

mylist_c <- compact_ids(mylist)

mylist_c <- compact_ids(mylist,startid=1001)

mylist <- data.frame("id" = c(11,12,13,14,15),
                     "canonical" = c("Hypochlorosis ancharia",
                                     "Pseudonotis humboldti",
                                     "Myrina ancharia",
                                     "Hypochlorosis ancharia obiana",
                                     "Hypochlorosis lorquinii"),
                     "family" = c("Lycaenidae", "Lycaenidae", 
                                  "Lycaenidae", "Lycaenidae",
                                  "Lycaenidae"),
                     "accid" = c(0,11,11,0,0),
                     "source" = c("itis","wiki","wiki","itis",
                                  "itis"),
                     stringsAsFactors = FALSE)
                     
mylist_c <- compact_ids(mylist)
}
}
\seealso{
Other List functions: 
\code{\link{DwC2taxo}()},
\code{\link{cast_cs_field}()},
\code{\link{get_synonyms}()},
\code{\link{match_lists}()},
\code{\link{melt_cs_field}()},
\code{\link{merge_lists}()},
\code{\link{syn2taxo}()},
\code{\link{synonymize_subspecies}()},
\code{\link{taxo2DwC}()},
\code{\link{taxo2doc}()},
\code{\link{taxo2syn}()},
\code{\link{wiki2taxo}()}
}
\concept{List functions}
