% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossplot.R
\name{crossplot}
\alias{crossplot}
\title{crossplot: Plot the median and HPD interval bars for pairs of distribution}
\usage{
crossplot(
  log1Path,
  log2Path,
  skip.char = "#",
  pattern = NULL,
  idx.cols = NULL,
  bar.lty,
  bar.lwd,
  identity.lty,
  identity.lwd,
  extra.space = 0.5,
  ...
)
}
\arguments{
\item{log1Path}{character vector of length 1. Path to the first log file.}

\item{log2Path}{character vector of length 1. Path to the second log file.}

\item{skip.char}{character vector of length 1, with '#' as default value.
Which symbol is used as a comment. This will allow to ignore lines which
start with the symbol when reading data.}

\item{pattern}{character vector of length 1. the pattern for subsetting the
columns containing the data to be plotted.}

\item{idx.cols}{either an integer vector with the position of the columns to
pick, or a character vector with the column names to pick. Defaults to NULL.}

\item{bar.lty}{The line type to be used as error bars.}

\item{bar.lwd}{As above but the width}

\item{identity.lty}{The line type to be used in
the identity y = x line}

\item{identity.lwd}{As above but the width.}

\item{extra.space}{numeric vector of length 1. How much space to be allowed
in both xlim and ylim depending on the smallest value in highest density
intervals plus or minus extra.space. A value of 0.5 units on the dimension
of interest is used by default.}

\item{...}{Optional arguments to be passed to `plot` such as `main`, `xlab`,
`ylab`, `pch` and `cex`.}
}
\value{
This function returns nothing, it plots to the graphical device.
}
\description{
crossplot: Plot the median and HPD interval bars for pairs of distribution
}
\details{
The function produces a crossplot, which is a scatterplot where we
are comparing two distributions associated to each point by means of the
medians as the points, and the highest density intervals as bars around the
point. For instance, x may represent the prior of a set of parameters while
y represents the posterior. Error bars on the x axis then are highest density
intervals from the prior, and those on the y axis represent the interval for
the posterior.

This function can also be used to compare two independent runs for
(visual) convergence: If they are sampling the same posterior distribution,
then they should fall on the identity y=x line.
}
\examples{
\dontrun{
crossplot(log1Path="log1.tsv", log2Path="log2.tsv", skip.char="#",
          pattern="par", cols=NULL, bar.lty=1, bar.lwd=1,
          identity.lty=2, identity.lwd=1,
          extra.space=0.5, main="My plot", xlab="log 1 (prior)", ylab="log 2 (posterior)", pch=19)
}
}
\author{
Gustavo A. Ballen
}
