% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/crosses.R
\name{permutDistTest}
\alias{permutDistTest}
\title{Monte Carlo permutation test for pairwise and one-vs-all-wise within- and inter-group differences in a set of repertoires.}
\usage{
permutDistTest(.mat, .groups, .n = 1000, .fun = mean, .signif = 0.05,
  .plot = T, .xlab = "Values",
  .title = "Monte Carlo permutation testing of overlaps", .hjust = -0.1,
  .vjust = -4)
}
\arguments{
\item{.mat}{Symmetric matrix of repertoire distances.}

\item{.groups}{Named list with names of repertoires in groups.}

\item{.n}{Number of permutations for each pair of group.}

\item{.fun}{A function to apply to distances.}

\item{.signif}{Significance level. Below this value hypotheses counts as significant.}

\item{.plot}{If T than plot the output results. Else return them as a data frame.}

\item{.xlab}{X lab label.}

\item{.title}{Main title of the plot.}

\item{.hjust}{Value for adjusting the x coordinate of p-value labels on plots.}

\item{.vjust}{Value for adjusting the y coordinate of p-value labels on plots.}
}
\description{
WARNING: this is an experimental procedure, work is still in progress.

Perform permutation tests of distances among groups for the given groups of samples and matrix of distances among all samples.
}
\examples{
\dontrun{
data(twb)
mat <- repOverlap(twb)
permutDistTest(mat, list(tw1 = c('Subj.A', 'Subj.B'), tw2 = c('Subj.C', 'Subj.D')))
permutDistTest(mat, list(tw1 = c('Subj.A', 'Subj.B'), tw2 = c('Subj.C', 'Subj.D')), .fun = median)
}
}
\seealso{
\link{repOverlap}, \link{intersectClonesets}, \link{ozScore}, \link{pca2euclid}
}

