% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_weights.R
\name{sp_weights}
\alias{sp_weights}
\title{Non parametric local heteroscedasticity weights}
\usage{
sp_weights(
  y,
  x,
  phi,
  use_phi = TRUE,
  preprocessed = FALSE,
  doPlot = FALSE,
  gene_based = FALSE,
  bw = c("nrd", "ucv", "SJ", "nrd0", "bcv"),
  kernel = c("gaussian", "epanechnikov", "rectangular", "triangular", "biweight",
    "tricube", "cosine", "optcosine"),
  exact = FALSE,
  transform = TRUE,
  verbose = TRUE,
  na.rm = FALSE
)
}
\arguments{
\item{y}{a numeric matrix of size \code{G x n} containing the raw RNA-seq counts or
preprocessed expression from \code{n} samples for \code{G} genes.}

\item{x}{a numeric matrix of size \code{n x p} containing the model covariate(s) from
\code{n} samples (design matrix).}

\item{phi}{a numeric design matrix of size \code{n x K} containing the K
variable(s) of interest( e.g. bases of time).}

\item{use_phi}{a logical flag indicating whether conditional means should be conditioned
on \code{phi} and on covariate(s) \code{x}, or on \code{x} alone. Default is
\code{TRUE} in which case conditional means are estimated conditionally on both
\code{x} and \code{phi}.}

\item{preprocessed}{a logical flag indicating whether the expression data have
already been preprocessed (e.g. log2 transformed). Default is \code{FALSE}, in
which case \code{y} is assumed to contain raw counts and is normalized into
log(counts) per million.}

\item{doPlot}{a logical flag indicating whether the mean-variance plot should be drawn.
Default is \code{FALSE}.}

\item{gene_based}{a logical flag indicating whether to estimate weights at the gene-level.
Default is \code{FALSE}, when weights will be estimated at the observation-level.}

\item{bw}{a character string indicating the smoothing bandwidth selection method to use. See
\code{\link[stats]{bandwidth}} for details. Possible values are \code{"ucv"}, \code{"SJ"},
\code{"bcv"}, \code{"nrd"} or \code{"nrd0"}. Default is \code{"nrd"}.}

\item{kernel}{a character string indicating which kernel should be used.
Possibilities are \code{"gaussian"}, \code{"epanechnikov"}, \code{"rectangular"},
\code{"triangular"}, \code{"biweight"}, \code{"tricube"}, \code{"cosine"},
\code{"optcosine"}. Default is \code{"gaussian"} (NB: \code{"tricube"} kernel
corresponds to the loess method).}

\item{exact}{a logical flag indicating whether the non-parametric weights accounting
for the mean-variance relationship should be computed exactly or extrapolated
from the interpolation of local regression of the mean against the
variance. Default is \code{FALSE}, which uses interpolation (faster).}

\item{transform}{a logical flag indicating whether values should be transformed to uniform
for the purpose of local linear smoothing. This may be helpful if tail observations are sparse and
the specified bandwidth gives suboptimal performance there. Default is \code{TRUE}.}

\item{verbose}{a logical flag indicating whether informative messages are printed
during the computation. Default is \code{TRUE}.}

\item{na.rm}{logical: should missing values (including \code{NA} and \code{NaN})
be omitted from the calculations? Default is \code{FALSE}.}
}
\value{
a \code{n x G} matrix containing the computed precision weights.
}
\description{
Computes precision weights that account for heteroscedasticity in RNA-seq count data
based on non-parametric local linear regression estimates.
}
\examples{
#rm(list = ls())
set.seed(123)

G <- 10000
n <- 12
p <- 2
y <- sapply(1:G, FUN = function(x){rnbinom(n = n, size = 0.07, mu = 200)})

x <- sapply(1:p, FUN = function(x){rnorm(n = n, mean = n, sd = 1)})



}
\seealso{
\code{\link[stats]{bandwidth}} \code{\link{density}}
}
