% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.pkmod}
\alias{plot.pkmod}
\alias{plot.pdmod}
\alias{plot.tciinf}
\alias{plot.datasim}
\alias{plot.bayessim}
\title{Plot object with class 'pkmod'}
\usage{
\method{plot}{pkmod}(x, ..., inf, npts = 1000, title = NULL)

\method{plot}{pdmod}(
  x,
  ...,
  pkmod,
  inf,
  pars_pd,
  pars_pk = NULL,
  npts = 1000,
  plot_pk = TRUE,
  title = NULL,
  ecmpt = NULL
)

\method{plot}{tciinf}(x, ..., title = NULL, display = TRUE)

\method{plot}{datasim}(x, ..., pars_prior = NULL, pars_post = NULL, pk_ix = NULL, pd_ix = NULL)

\method{plot}{bayessim}(x, ...)
}
\arguments{
\item{x}{Object returned from "bayes_control" function}

\item{...}{\dots}

\item{inf}{An infusion schedule object with columns "begin","end","infrt".}

\item{npts}{Number of points used to evaluate predicted concentrations.}

\item{title}{Title of plot.}

\item{pkmod}{PK model}

\item{pars_pd}{Parameters used by pdmod.}

\item{pars_pk}{Parameters used by pkmod.}

\item{plot_pk}{Logical. Should PK concentrations be plotted alongside
the PD response. Defaults to TRUE.}

\item{ecmpt}{Effect-site compartment number. Defaults to the last
compartment concentration returned by pkmod.}

\item{display}{Logical. Should plots be printed or returned as an arrangeGrob object?}

\item{pars_prior}{Named vector of prior PK or PK-PD parameters}

\item{pars_post}{Named vector of posterior PK or PK-PD parameters}

\item{pk_ix}{Indicies of parameter vector(s) corresponding to PK parameters}

\item{pd_ix}{Indicies of parameter vector(s) corresponding to PD parameters}
}
\value{
Returns a ggplot2 object displaying concentrations over time associated
with object x with class 'pkmod'.

Returns a ggplot2 object displaying responses and optional concentrations
over time associated with object x with class 'pkmod'.

Returns a gridExtra grob object displaying responses and concentrations
over time associated with an infusion schedule with class 'tciinf'.

Returns a ggplot2 plot displaying simulated results from an object with
class 'datasim'.

Returns a ggplot2 plot displaying results stored in a object
with class 'bayessim'.
}
\description{
Will show predicted concentrations in compartments associated with an infusion schedule.

User can provide a series of effect-site concentrations and a PD model or
 an infusion schedule with a PK-PD model.

Plot output returned by "bayes_control" function.
}
