% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_mods.R
\name{emax_eleveld}
\alias{emax_eleveld}
\title{Emax function for Eleveld (2018) model.}
\usage{
emax_eleveld(ce, pars)
}
\arguments{
\item{ce}{Vector of effect-site concentrations.}

\item{pars}{Vector of parameter values in order (c50,gamma,gamma2,e0,emx).}
}
\description{
The parameter gamma takes one of two values depending on whether ce <= c50.
}
\examples{
pars_emax_eleveld <- c(c50 = 1.5, gamma = 1.47, gamma2 = 1.89, e0 = 100, emx = 100)
ce_seq <- seq(0,4,0.1)
plot(ce_seq, emax_eleveld(ce_seq, pars_emax_eleveld), type = "l",
xlab = "Effect-site concentrtion (ug/mL)", ylab = "BIS")
}
