% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tci_algorithms.R
\name{apply_tci}
\alias{apply_tci}
\title{Apply a TCI algorithm to a `pkmod` object}
\usage{
apply_tci(
  pkmod,
  target_vals,
  target_tms,
  type = c("plasma", "effect"),
  dtm = NULL,
  custom_alg = NULL,
  inittm = 0,
  ignore_pd = FALSE,
  ...
)
}
\arguments{
\item{pkmod}{`pkmod` object created by `pkmod()`.}

\item{target_vals}{A vector of numeric values indicating PK or PD targets for TCI algorithm.}

\item{target_tms}{A vector of numeric values indicating times at which the TCI algorithm should
begin targeting each value.}

\item{type}{Type of TCI algorithm to be used. Options are plasma- or effect-site
targeting.}

\item{dtm}{TCI update frequency. Defaults to 1/6, corresponding to 10-second
intervals if model parameters are in terms of minutes.}

\item{custom_alg}{Custom TCI algorithm to be used instead of default plasma-
or effect-site targeting algorithms. The algorithm should be a function that
takes minimum arguments `Ct`, `pkmod`, and `dtm` and returns a single infusion
rate. See `tci_plasma` or `tci_effect` for examples and vignette on custom
models/algorithms for more details.}

\item{inittm}{Initial time to start TCI algorithm. Cannot be greater than
the minimum value of `target_tms`.}

\item{ignore_pd}{Logical. Should the PD component of the pkmod object (if present)
be ignored. By default, predict.tciinf will assume that 'value' refers to PD
targets if a PD model is specified.}

\item{...}{Arguments passed to TCI algorithm}
}
\description{
Apply a TCI algorithm to a set of targets and a `pkmod` object to calculate infusion
rates.
}
\examples{
# 3-compartment model with effect-site
my_mod <- pkmod(pars_pk = c(v1 = 8.995, v2 = 17.297, v3 = 120.963, cl = 1.382,
q2 = 0.919, q3 = 0.609, ke0 = 1.289))
# plasma targeting
apply_tci(my_mod, target_vals = c(2,3,4,4), target_tms = c(0,2,3,10), "plasma")
# effect-site targeting
apply_tci(my_mod, target_vals = c(2,3,4,4), target_tms = c(0,2,3,10), "effect")
# incorporate  PD model
my_mod_pd <- update(my_mod, pars_pd = c(c50 = 2.8, gamma = 1.47, e0 = 93, emx = 93),
pdfn = emax, pdinv = emax_inv)
apply_tci(my_mod_pd, target_vals = c(70,60,50,50), target_tms = c(0,2,3,10), "effect")
}
