% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLTM_test.R
\name{LLTM_test}
\alias{LLTM_test}
\title{Testing linear restrictions on parameter space of item parameters of RM.}
\usage{
LLTM_test(X, W)
}
\arguments{
\item{X}{Data matrix.}

\item{W}{Design matrix of LLTM.}
}
\value{
A list of test statistics, degrees of freedom, and p-values.
 \item{test}{A numeric vector of gradient (GR), likelihood ratio (LR), Rao score (RS), and Wald test statistics.}
 \item{df}{Degrees of freedom.}
 \item{pvalue}{A vector of corresponding p-values.}
 \item{call}{The matched call.}
}
\description{
Computes gradient (GR), likelihood ratio (LR), Rao score (RS) and Wald (W) test statistics for
  hypotheses defined by linear restrictions on parameter space of the item parameters of RM.
}
\details{
The RM item parameters are assumed to be linear in the LLTM parameters.
 The coefficients of the linear functions are specified by a design matrix W. In this context,
 the LLTM is considered as a more parsimonious model than the RM. The LLTM parameters can be
 interpreted as the difficulties of certain cognitive operations needed to respond correctly
 to psychological test items. The item parameters of the RM are assumed to be linear combinations
 of these cognitive operations. These linear combinations are defined in the design matrix W.
}
\examples{
\dontrun{
# Numerical example assuming no deviation from linear restriction

# design matrix W defining linear restriction
W <- rbind(c(1,0), c(0,1), c(1,1), c(2,1))

# assumed eta parameters of LLTM for data generation
eta <- c(-0.5, 1)

# assumed vector of item parameters of RM
b <- colSums(eta * t(W))

y <- eRm::sim.rasch(persons = rnorm(400), items = b - b[1])  # sum0 = FALSE

res <- LLTM_test(X = y, W = W )

res$test # test statistics
res$df # degrees of freedoms
res$pvalue # p-values

}
}
\references{
{
 Fischer, G. H. (1995). The Linear Logistic Test Model. In G. H. Fischer & I. W. Molenaar (Eds.),
 Rasch models: Foundations, Recent Developments, and Applications (pp. 131-155). New York: Springer.

 Fischer, G. H. (1983). Logistic Latent Trait Models with Linear Constraints. Psychometrika, 48(1), 3-26.
 }
}
\seealso{
\code{\link{change_test}}, and \code{\link{invar_test}}.
}
\keyword{htest}
