% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc3.R
\name{mc3}
\alias{mc3}
\title{Perform level 3  
multiple-concentration processing}
\usage{
mc3(ac, wr = FALSE)
}
\arguments{
\item{ac}{Integer of length 1, assay component id (acid) for processing.}

\item{wr}{Logical, whether the processed data should be written to the tcpl
database}
}
\value{
A boolean of length 1, indicating the success of the processing, or 
when 'wr' is FALSE, a list where the first element is a boolean indiciating 
the success of processing and the second element is a data.table containing 
the processed data
}
\description{
\code{mc3} loads level 2 data from the tcpl 
database for the given id and performs level 3 
multiple-concentration processing. 
The processed data is then loaded into the mc3 table and 
all subsequent data is deleted with \code{\link{tcplCascade}}. See details 
for more information.

The individual processing functions are no longer exported, as it is 
typically more convenient and suggested to use the \code{\link{tcplRun}} 
wrapper function.
}
\details{
Level 3 multiple-concentration processing includes mapping assay component
to assay endpoint, duplicating the data when the assay component has
multiple assay endpoints, and any normalization of the data. Data
normalization based on methods listed in mc3_aeid and mc3_methods tables.
}
\seealso{
\code{\link{Method functions}}, \code{\link{MC3_Methods}}

Other multiple-concentration data 
processing functions: \code{\link{mc1}},
  \code{\link{mc2}}, \code{\link{mc4}}, \code{\link{mc5}},
  \code{\link{mc6}}
}
