% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc1_mthds.R
\name{SC1_Methods}
\alias{SC1_Methods}
\alias{sc1_mthds}
\title{List of level 1 single-concentration normalization functions}
\usage{
sc1_mthds()
}
\value{
A list functions
}
\description{
\code{sc1_mthds} returns a list of functions to be used during level 1 
single-concentration processing.
}
\details{
The functions contained in the list returned by \code{sc1_mthds} return
a list of expressions to be executed in the \code{sc2} (not exported) 
function environment. The functions are described here for reference 
purposes, The \code{sc1_mthds} function is not exported, nor is it 
intended for use.

All available methods are described in the Available Methods section, listed
by the function/method name.
}
\note{
This function is not exported and is not intended to be used by the user.
}
\section{Available Methods}{


The methods are broken into three types, based on what fields they define. 
Different methods are used to define "bval" (the baseline value), "pval"
(the positive control value), and "resp" (the final response value). 

Although it does not say so specifically in each description, all methods 
are applied by acid.

More information about the level 3 single-concentration processing is 
available in the package vignette, "Data_processing."

\subsection{bval Methods}{
  \describe{
    \item{bval.apid.nwlls.med}{Calculate the baseline value (bval) as the plate-wise median,
     by assay plate ID (apid), of the raw values (rval) for neutral control wells (wllt = n).}
    \item{bval.apid.twlls.med}{Calculate the baseline value (bval) as the plate-wise median,
     by assay plate ID (apid), of the raw values (rval) for test compound wells (wllt = t).}
    \item{bval.apid.tn.med}{Calculate the baseline value (bval) as the plate-wise median,
     by assay plate ID (apid), of the raw values (rval) for test compound wells (wllt = t)
      and neutral control wells (wllt = n).}
  }
} 

\subsection{pval Methods}{
  \describe{
    \item{pval.apid.pwlls.med}{Calculate the positive control value (pval) as the plate-wise 
    median, by assay plate ID (apid), of the raw values (rval) for single-concentration 
    gain-of-signal positive control wells (wllt = p).}
    \item{pval.apid.mwlls.med}{Calculate the positive control value (pval) as the plate-wise 
    median, by assay plate ID (apid), of the raw values (rval) for multiple-concentration 
    loss-of-signal negative control wells (wllt = m).}
    \item{pval.apid.medpcbyconc.max}{Calculate the positive control value (pval) as the 
    plate-wise maximum, by assay plate ID (apid), of the medians of the raw values (rval) for 
    gain-of-signal single- or multiple-concentration positive control wells (wllt = p or c) by 
    apid, well type, and concentration.}
    \item{pval.apid.medpcbyconc.min}{Calculate the positive control value (pval) as the 
    plate-wise minimum, by assay plate ID (apid), of the medians of the raw values (rval) for 
    gain-of-signal single- or multiple-concentration positive control wells (wllt = p or c) by 
    apid, well type, and concentration.}
    \item{pval.apid.medncbyconc.min}{Calculate the positive control value (pval) as the 
    plate-wise minimum, by assay plate ID (apid), of the medians of the raw values (rval) for 
    gain-of-signal single- or multiple-concentration negative control wells (wllt = m or o) by 
    apid, well type, and concentration.}
    \item{pval.zero}{Set the positive control value (pval) to 0; pval = 0.}
    \item{pval.apid.or.aeid.pwlls.med}{Calculate the positive control value (pval) as the 
    plate-wise median, by assay plate ID (apid), of the raw values (rval) for 
    single-concentration gain-of-signal positive control wells (wllt = p). For plates without p 
    wells, set the pval as the median pval calculated from all plates.}
  }
} 

\subsection{resp Methods}{
  \describe{
    \item{resp.pc}{Calculate the normalized response (resp) as a percent of control, i.e. the 
    ratio of the difference between the raw (rval) and baseline (bval) values divided by the 
    difference between positive control (pval) and baseline (bval) values multiplied by 100; 
    \eqn{resp=(rval-bval)/(pval-bval)*100}{resp=(rval-bval)/(pval-bval)*100}.}
    \item{resp.fc}{Calculate the normalized response (resp) as fold change, i.e. the ratio of 
    the raw (rval) and baseline (bval) values; \eqn{resp = rval/bval}{resp = rval/bval}.}
    \item{resp.logfc}{Calculate the normalized response (resp) as the fold change of logged,
     i.e. the difference between raw (rval) and baseline (bval) log-scale values.}
    \item{resp.log2}{Transform the response values to log-scale (base 2).}
    \item{resp.multneg1}{Multiply the normalized response value (resp) by -1; 
    \eqn{-1*resp}{-1*resp}.}
    \item{none}{Use raw value (rval) as is. This may be necessary for additional 
    endpoint-specific adjustments, or where no additional sc1 methods are needed.}
    \item{resp.incr.zerocenter.fc}{Calculate the normalized response (resp) as a zero center 
    fold change, i.e. the ratio of the raw (rval) and baseline (bval) values minus 1; 
    \eqn{resp=rval/bval-1}{resp=rval/bval-1}. Typically used for increasing responses.}
  }
}
}

\seealso{
\code{\link{sc1}}, \code{\link{Method functions}} to query what
methods get applied to each acid
}
