% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{data.vesta.fraud}
\alias{data.vesta.fraud}
\title{Load 'Vesta' Dataset}
\usage{
data.vesta.fraud(
  dirPath,
  training = TRUE,
  tranDumCols = NULL,
  idenDumCols = NULL,
  catMinSkip = 6
)
}
\arguments{
\item{dirPath}{Path to the downloaded data directory.}

\item{training}{If \code{FALSE}, it loads test data.}

\item{tranDumCols}{A list with \code{name} and \code{values} of (categorical) columns in 'transaction' file to be converted to dummy variables. If \code{training} is \code{FALSE} and this is \code{NULL}, a warning is raised.}

\item{idenDumCols}{Similar to \code{tranDumCols} but for 'identity' file.}

\item{catMinSkip}{If \code{tranDumCols} or \code{idenDumCols} is \code{NULL}, for a categorical variable, if number of unique values is equal or larger than this value, it is omitted.}
}
\value{
A list with the following items:
\tabular{ll}{
\code{data} \tab A \code{data.frame} with the data. \cr
\code{tranDumCols} \tab A list with \code{name} and \code{values} in 'transaction' data, used for creating the dummy variable. \cr
\code{idenDumCols} \tab A list with \code{name} and \code{values} in 'identity' data, used for creating the dummy variable.
}
}
\description{
Use it to create fraud-series table from 'Vesta' dataset (aka IEEE-CIS Fraud Detection).
}
