% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable.R
\name{variable}
\alias{variable}
\title{Creates a Variable}
\usage{
variable(data, startFrequency = NULL, name = NULL, fields = NULL)
}
\arguments{
\item{data}{Data of the variable.}

\item{startFrequency}{Frequency of the first element.}

\item{name}{Name of the variable.}

\item{fields}{A list that contains named fields.}
}
\value{
An object of class \code{ldtv}. This is also a list with the following memebers:
\itemize{
\item \strong{data:} Determines the \code{data}.
\item \strong{name:} Determines the \code{name}.
\item \strong{startFrequency:} Determines the \code{startFrequency}.
\item \strong{fields:} Determines the \code{fields}.
}
}
\description{
Use this to create data array with a frequency. It can have a name and other named fields.
}
\examples{
data <- c(1,2,3,2,3,4,5)
start_f <- f.monthly(2022,12)
fields <- list(c("key1","value1"), c("key2", "value2"))
v1 = variable(data, start_f, "V1", fields)
}
