% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert.to.weekly}
\alias{convert.to.weekly}
\title{Convert Data to Weekly Frequency}
\usage{
convert.to.weekly(variable, weekStart, aggregateFun)
}
\arguments{
\item{variable}{A variable.}

\item{weekStart}{Determines the start day of the week, can be \code{sun}, \code{mon}, \code{tue}, \code{wed}, \code{thu}, \code{fri}, or \code{sat}.}

\item{aggregateFun}{Function to aggregate data within each interval.}
}
\value{
A variable with weekly frequency.
}
\description{
Use this function to convert time-series data (currently implemented: daily) to time-series data with weekly frequency.
}
\details{
See the details section of the \code{\link{convert.to.daily}} function.
}
\examples{
startFreq <- f.daily(c(2022, 9, 1))
v <- variable(c(1,2,3,4,5,6,7,8), startFreq)
w <- convert.to.weekly(v, "mon", function(x)mean(x, na.rm=TRUE))

}
