\name{GaussQuadrature}
\alias{grule}
\alias{gweights}
\title{Gaussian quadrature weights}
\description{The \code{grule} computes Gauss base points and weight factors for
Gaussian quadrature on interval [0 1] and the \code{gweights} is the generator
of points and weight factors for the Gaussian quadrature on several different
subintervals.}
\usage{
grule(n)
gweights(limits, ms, bp, wf)
}
\arguments{
\item{n}{number of base points and weight factors}
\item{limits}{borders of subintervals.}
\item{ms}{number of base points in particular subinterval.}
\item{bp}{base points of the Gaussian quadrature genterated by \code{grule} on 
interval [0 1].}
\item{wf}{weight factors of the Gaussian quadrature genterated by \code{grule}
on interval [0 1].}
}
\details{The \code{gweights} divides the whole interval into \code{ms[i]}
subintervals given by \code{limits[i]} and \code{limits[i + 1]} and the
integration over each subinterval is done with an \code{nquad} point Gauss
formula which involves base points BP and weight factors WF. The normalized
interval of integration for the BP and WF constants is 0 to 1. The base points
and weight factors must first be generated by a call to grule.}
\value{
The \code{grule} generates a list of
\item{bp}{base points on interval [0 1].}
\item{wf}{weight factors on interval [0 1].}
The \code{gweights} generates a list of
\item{tt}{base points of all subintervals.}
\item{w}{weight factors of all subintervals.}
}
\references{Davis, Rabinowitz (1975), \emph{Methods of Numerical Integration}.
Academic Press, page 365.}
\author{Gordon K Smyth, STATBOX 4.1 \email{smyth@wehi.edu.au}. Rewritten from
Matlab algorithm to R by Alexander Savin \email{savin@savba.sk}.}
\keyword{math}
