\name{hall}
\alias{hall}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
A Single Bootstrap Procedure for Choosing the Optimal Sample Fraction
}
\description{
An Implementation of the procedure proposed in Hall (1990) for selecting the optimal sample fraction in tail index estimation}
\usage{
hall(data, B = 1000, epsilon = 0.955, kaux = 2 * sqrt(length(data)))
}
\arguments{
  \item{data}{
vector of sample data
}
  \item{B}{
number of Bootstrap replications
}
  \item{epsilon}{
gives the amount of the resampling size \code{n1} by choosing \code{n1 = n^epsilon}. Default is set to \code{epsilon=0.955}
}
  \item{kaux}{
tuning parameter for the hill estimator
}
}
\details{
The Bootstrap procedure simulates the AMSE criterion of the Hill estimator. The unknown theoretical parameter of the inverse tail index \code{gamma} is replaced by a consistent estimation using a tuning parameter \code{kaux} for the Hill estimator. Minimizing this statistic gives a consistent estimator of the sample fraction \code{k/n} with \code{k} the optimal number of upper order statistics. This number, denoted \code{k0} here, is equivalent to the number of extreme values or, if you wish, the number of exceedances in the context of a POT-model like the generalized Pareto distribution. \code{k0} can then be associated with the unknown threshold \code{u} of the GPD by choosing \code{u} as the \code{n-k0}th upper order statistic. For more information see references.

}
\value{
   \item{k0}{optimal number of upper order statistics, i.e. number of exceedances or data in the tail}
  \item{threshold}{the corresponding threshold}
  \item{tail.index}{the corresponding tail index}
}
\references{
Hall, P. (1990)
Using the Bootstrap to Estimate Mean Squared Error and Select Smoothing Parameter in Nonparametric Problems.
\emph{Journal of Multivariate Analysis}, \bold{32}, 177--203
}
\examples{
data(danish)
hall(danish)
}