% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qenv-concat.R
\name{concat}
\alias{concat}
\alias{concat,qenv,qenv-method}
\alias{concat,qenv.error,ANY-method}
\alias{concat,qenv,qenv.error-method}
\title{Concatenate two \code{qenv} objects}
\usage{
concat(x, y)

\S4method{concat}{qenv,qenv}(x, y)

\S4method{concat}{qenv.error,ANY}(x, y)

\S4method{concat}{qenv,qenv.error}(x, y)
}
\arguments{
\item{x}{(\code{qenv})}

\item{y}{(\code{qenv})}
}
\value{
\code{qenv} object.
}
\description{
Combine two \code{qenv} objects by simple concatenate their environments and the code.
We recommend to use the \code{join} method to have a stricter control
in case \code{x} and \code{y} contain duplicated bindings and code.
RHS argument content has priority over the LHS one.
}
\examples{
q1 <- new_qenv(
  code = c(iris1 = "iris1 <- iris", mtcars1 = "mtcars1 <- mtcars"),
  env = list2env(list(
    iris1 = iris,
    mtcars1 = mtcars
  ))
)
q2 <- q1
q1 <- eval_code(q1, "iris2 <- iris")
q2 <- eval_code(q2, "mtcars2 <- mtcars")
qq <- concat(q1, q2)
get_code(qq)
}
