% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_keys.R, R/join_keys-extract.R,
%   R/join_keys-c.R, R/join_keys-print.R
\name{join_keys}
\alias{join_keys}
\alias{join_keys.default}
\alias{join_keys.join_keys}
\alias{join_keys.teal_data}
\alias{[.join_keys}
\alias{[<-.join_keys}
\alias{c.join_keys}
\alias{c.join_key_set}
\alias{join_keys<-}
\alias{join_keys<-.join_keys}
\alias{join_keys<-.teal_data}
\alias{format.join_keys}
\alias{print.join_keys}
\title{Manage relationships between datasets using \code{join_keys}}
\usage{
## Constructor, getter and setter
join_keys(...)

\method{join_keys}{default}(...)

\method{join_keys}{join_keys}(...)

\method{join_keys}{teal_data}(...)

\method{[}{join_keys}(x, i, j)

\method{[}{join_keys}(x, i, j, directed = TRUE) <- value

\method{c}{join_keys}(...)

\method{c}{join_key_set}(...)

join_keys(x) <- value

\method{join_keys}{join_keys}(x) <- value

\method{join_keys}{teal_data}(x) <- value

\method{format}{join_keys}(x, ...)

\method{print}{join_keys}(x, ...)
}
\arguments{
\item{...}{(optional)
\itemize{
\item either \code{teal_data} or \code{join_keys} object to extract \code{join_keys}
\item or any number of \code{join_key_set} objects to create \code{join_keys}
\item or nothing to create an empty \code{join_keys}
}}

\item{x}{(\code{join_keys}) empty object to set the new relationship pairs.
\code{x} is typically an object of \code{join_keys} class. When called with the \code{join_keys(x)}
or \code{join_keys(x) <- value} then it can also take a supported class (\code{teal_data}, \code{join_keys})}

\item{i, j}{indices specifying elements to extract or replace. Index should be a
a character vector, but it can also take numeric, logical, \code{NULL} or missing.}

\item{directed}{(\code{logical(1)}) Flag that indicates whether it should create
a parent-child relationship between the datasets.
\itemize{
\item \code{TRUE} (default) \code{dataset_1} is the parent of \code{dataset_2};
\item \code{FALSE} when the relationship is undirected.
}}

\item{value}{For \verb{x[i, j, directed = TRUE)] <- value} (named/unnamed \code{character})
Column mapping between datasets.

For \code{join_keys(x) <- value}: (\code{join_key_set} or list of \code{join_key_set}) relationship
pairs to add to \code{join_keys} list.

[i, j, directed = TRUE)]: R:i,\%20j,\%20directed\%20=\%20TRUE)}
}
\value{
\code{join_keys} object.
}
\description{
Facilitates the creation and retrieval of relationships between datasets.
\code{join_keys} class extends \code{list} and contains keys connecting pairs of datasets.
Each element of the list contains keys for specific dataset.
Each dataset can have a relationship with itself (primary key) and with other datasets.

Note that \code{join_keys} list is symmetrical and assumes a default direction, that is:
when keys are set between \code{ds1} and \code{ds2}, it defines \code{ds1} as the parent
in a parent-child relationship and the mapping is automatically mirrored between
\code{ds2} and \code{ds1}.
}
\section{Methods (by class)}{

\itemize{
\item \code{join_keys()}: Returns an empty \code{join_keys} object when called without arguments.
\item \code{join_keys(join_keys)}: Returns itself.
\item \code{join_keys(teal_data)}: Returns the \code{join_keys} object contained in \code{teal_data} object.
\item \code{join_keys(...)}: Creates a new object with one or more \code{join_key_set} parameters.
}
}

\section{Functions}{

\itemize{
\item \code{x[datanames]}: Returns a subset of the \code{join_keys} object for
given \code{datanames}, including parent \code{datanames} and symmetric mirror keys between
\code{datanames} in the result.
\item \code{x[i, j]}: Returns join keys between datasets \code{i} and \code{j},
including implicit keys inferred from their relationship with a parent.
}


\itemize{
\item \code{x[i, j] <- value}: Assignment of a key to pair \verb{(i, j)}.
\item \code{x[i] <- value}: This (without \code{j} parameter) \strong{is not} a supported
operation for \code{join_keys}.
\item \code{join_keys(x)[i, j] <- value}: Assignment to \code{join_keys} object stored in \code{x},
such as a \code{teal_data} object or \code{join_keys} object itself.
}


\itemize{
\item \code{join_keys(x) <- value}: Assignment of the \code{join_keys} in object with \code{value}.
\code{value} needs to be an object of class \code{join_keys} or \code{join_key_set}.
}
}

\examples{
# Creating a new join keys ----

jk <- join_keys(
  join_key("ds1", "ds1", "pk1"),
  join_key("ds2", "ds2", "pk2"),
  join_key("ds3", "ds3", "pk3"),
  join_key("ds1", "ds2", c(pk1 = "pk2")),
  join_key("ds1", "ds3", c(pk1 = "pk3"))
)

jk


# Getter for join_keys ---

jk["ds1", "ds2"]

# Subsetting join_keys ----

jk["ds1"]
jk[1:2]
jk[c("ds1", "ds2")]


# Setting a new primary key ---

jk["ds4", "ds4"] <- "pk4"
jk["ds5", "ds5"] <- "pk5"

# Setting a single relationship pair ---

jk["ds1", "ds4"] <- c("pk1" = "pk4")

# Removing a key ---

jk["ds5", "ds5"] <- NULL
# Merging multiple `join_keys` objects ---

jk_merged <- c(
  jk,
  join_keys(
    join_key("ds4", keys = c("pk4", "pk4_2")),
    join_key("ds3", "ds4", c(pk3 = "pk4_2"))
  )
)
# note: merge can be performed with both join_keys and join_key_set

jk_merged <- c(
  jk_merged,
  join_key("ds5", keys = "pk5"),
  join_key("ds1", "ds5", c(pk1 = "pk5"))
)

# Assigning keys via join_keys(x)[i, j] <- value ----

obj <- join_keys()
# or
obj <- teal_data()

join_keys(obj)["ds1", "ds1"] <- "pk1"
join_keys(obj)["ds2", "ds2"] <- "pk2"
join_keys(obj)["ds3", "ds3"] <- "pk3"
join_keys(obj)["ds1", "ds2"] <- c(pk1 = "pk2")
join_keys(obj)["ds1", "ds3"] <- c(pk1 = "pk3")

identical(jk, join_keys(obj))

# Setter for join_keys within teal_data ----

td <- teal_data()
join_keys(td) <- jk

join_keys(td)["ds1", "ds2"] <- "new_key"
join_keys(td) <- c(join_keys(td), join_keys(join_key("ds3", "ds2", "key3")))
join_keys(td)
}
\seealso{
\code{\link[=join_key]{join_key()}} for creating \code{join_keys_set},
\code{\link[=parents]{parents()}} for parent operations,
\code{\link[=teal_data]{teal_data()}} for \code{teal_data} constructor \emph{and}
\link{default_cdisc_join_keys} for default CDISC keys.
}
