% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_events_summary.R
\name{template_events_summary}
\alias{template_events_summary}
\title{Template: Adverse Events Summary}
\usage{
template_events_summary(
  anl_name,
  parentname,
  arm_var,
  dthfl_var = "DTHFL",
  dcsreas_var = "DCSREAS",
  flag_var_anl = NULL,
  flag_var_aesi = NULL,
  aeseq_var = "AESEQ",
  llt = "AEDECOD",
  add_total = TRUE,
  total_label = default_total_label(),
  na_level = default_na_str(),
  count_dth = TRUE,
  count_wd = TRUE,
  count_subj = TRUE,
  count_pt = TRUE,
  count_events = TRUE
)
}
\arguments{
\item{anl_name}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{dthfl_var}{(\code{character})\cr name of variable for subject death flag from \code{parentname}.
Records with \code{"Y"} are summarized in the table row for "Total number of deaths".}

\item{dcsreas_var}{(\code{character})\cr name of variable for study discontinuation reason from \code{parentname}.
Records with \code{"ADVERSE EVENTS"} are summarized in the table row for
"Total number of patients withdrawn from study due to an AE".}

\item{flag_var_anl}{(\code{character})\cr name of flag variable from \code{dataset} used to count adverse event sub-groups
(e.g. Serious events, Related events, etc.). Variable labels are used as table row names if they exist.}

\item{flag_var_aesi}{(\code{character})\cr name of flag variable from \code{dataset} used to count adverse event special
interest groups. All flag variables must be of type \code{logical}. Variable labels are used as table row names if
they exist.}

\item{aeseq_var}{(\code{character})\cr name of variable for adverse events sequence number from \code{dataset}. Used for
counting total number of events.}

\item{llt}{(\code{character})\cr name of the variable with low level term for events.}

\item{add_total}{(\code{logical})\cr whether to include column with total number of patients.}

\item{total_label}{(\code{string})\cr string to display as total column/row label if column/row is
enabled (see \code{add_total}). Defaults to \code{"All Patients"}. To set a new default \code{total_label} to
apply in all modules, run \code{set_default_total_label("new_default")}.}

\item{na_level}{(\code{string})\cr used to replace all \code{NA} or empty values
in character or factor variables in the data. Defaults to \code{"<Missing>"}. To set a
default \code{na_level} to apply in all modules, run \code{set_default_na_str("new_default")}.}

\item{count_dth}{(\code{logical})\cr whether to show count of total deaths (based on \code{dthfl_var}). Defaults to \code{TRUE}.}

\item{count_wd}{(\code{logical})\cr whether to show count of patients withdrawn from study due to an adverse event
(based on \code{dcsreas_var}). Defaults to \code{TRUE}.}

\item{count_subj}{(\code{logical})\cr whether to show count of unique subjects (based on \code{USUBJID}). Only applies if
event flag variables are provided.}

\item{count_pt}{(\code{logical})\cr whether to show count of unique preferred terms (based on \code{llt}). Only applies if
event flag variables are provided.}

\item{count_events}{(\code{logical})\cr whether to show count of events (based on \code{aeseq_var}). Only applies if event
flag variables are provided.}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate an adverse events summary table.
}
\seealso{
\code{\link[=tm_t_events_summary]{tm_t_events_summary()}}
}
\keyword{internal}
