% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_abnormality.R
\name{tm_t_abnormality}
\alias{tm_t_abnormality}
\title{teal Module: Abnormality Summary Table}
\usage{
tm_t_abnormality(
  label,
  dataname,
  parentname = ifelse(inherits(arm_var, "data_extract_spec"),
    teal.transform::datanames_input(arm_var), "ADSL"),
  arm_var,
  by_vars,
  grade,
  abnormal = list(low = c("LOW", "LOW LOW"), high = c("HIGH", "HIGH HIGH")),
  id_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    subset = "USUBJID"), selected = "USUBJID", fixed = TRUE),
  baseline_var =
    teal.transform::choices_selected(teal.transform::variable_choices(dataname, subset =
    "BNRIND"), selected = "BNRIND", fixed = TRUE),
  treatment_flag_var =
    teal.transform::choices_selected(teal.transform::variable_choices(dataname, subset =
    "ONTRTFL"), selected = "ONTRTFL", fixed = TRUE),
  treatment_flag = teal.transform::choices_selected("Y"),
  add_total = TRUE,
  total_label = default_total_label(),
  exclude_base_abn = FALSE,
  drop_arm_levels = TRUE,
  pre_output = NULL,
  post_output = NULL,
  na_level = default_na_str(),
  basic_table_args = teal.widgets::basic_table_args(),
  transformators = list(),
  decorators = list()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for variable names that can be used as \code{arm_var}.
It defines the grouping variable in the results table.}

\item{by_vars}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for variable names used to split the summary by rows.}

\item{grade}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr
object with all available choices and preselected option for variable names that can be used to
specify the abnormality grade. Variable must be factor.}

\item{abnormal}{(\verb{named list})\cr defined by user to indicate what abnormalities are to be displayed.}

\item{id_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object specifying
the variable name for subject id.}

\item{baseline_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr
variable for baseline abnormality grade.}

\item{treatment_flag_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr on
treatment flag variable.}

\item{treatment_flag}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr value
indicating on treatment records in \code{treatment_flag_var}.}

\item{add_total}{(\code{logical})\cr whether to include column with total number of patients.}

\item{total_label}{(\code{string})\cr string to display as total column/row label if column/row is
enabled (see \code{add_total}). Defaults to \code{"All Patients"}. To set a new default \code{total_label} to
apply in all modules, run \code{set_default_total_label("new_default")}.}

\item{exclude_base_abn}{(\code{logical})\cr whether to exclude patients who had abnormal values at baseline.}

\item{drop_arm_levels}{(\code{logical})\cr whether to drop unused levels of \code{arm_var}. If \code{TRUE}, \code{arm_var} levels are
set to those used in the \code{dataname} dataset. If \code{FALSE}, \code{arm_var} levels are set to those used in the
\code{parentname} dataset. If \code{dataname} and \code{parentname} are the same, then \code{drop_arm_levels} is set to \code{TRUE} and
user input for this parameter is ignored.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{na_level}{(\code{character})\cr the NA level in the input dataset, default to \code{"<Missing>"}.}

\item{basic_table_args}{(\code{basic_table_args}) optional\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{decorators}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
(named \code{list} of lists of \code{teal_transform_module}) optional,
decorator for tables or plots included in the module output reported.
The decorators are applied to the respective output objects.

See section "Decorating Module" below for more details.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a table to summarize abnormality.
}
\note{
Patients with the same abnormality at baseline as on the treatment visit can be
excluded in accordance with GDSR specifications by using \code{exclude_base_abn}.
}
\section{Decorating Module}{


This module generates the following objects, which can be modified in place using decorators:
\itemize{
\item \code{table} (\code{TableTree} - output of \code{rtables::build_table()})
}

A Decorator is applied to the specific output using a named list of \code{teal_transform_module} objects.
The name of this list corresponds to the name of the output to which the decorator is applied.
See code snippet below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tm_t_abnormality(
   ..., # arguments for module
   decorators = list(
     table = teal_transform_module(...) # applied only to `table` output
   )
)
}\if{html}{\out{</div>}}

For additional details and examples of decorators, refer to the vignette
\code{vignette("decorate-module-output", package = "teal.modules.clinical")}.

To learn more please refer to the vignette
\code{vignette("transform-module-output", package = "teal")} or the \code{\link[teal:teal_transform_module]{teal::teal_transform_module()}} documentation.
}

\examples{
library(dplyr)

data <- teal_data()
data <- within(data, {
  ADSL <- tmc_ex_adsl
  ADLB <- tmc_ex_adlb \%>\%
    mutate(
      ONTRTFL = case_when(
        AVISIT \%in\% c("SCREENING", "BASELINE") ~ "",
        TRUE ~ "Y"
      ) \%>\% with_label("On Treatment Record Flag")
    )
})
join_keys(data) <- default_cdisc_join_keys[names(data)]

ADSL <- data[["ADSL"]]
ADLB <- data[["ADLB"]]

app <- init(
  data = data,
  modules = modules(
    tm_t_abnormality(
      label = "Abnormality Table",
      dataname = "ADLB",
      arm_var = choices_selected(
        choices = variable_choices(ADSL, subset = c("ARM", "ARMCD")),
        selected = "ARM"
      ),
      add_total = FALSE,
      by_vars = choices_selected(
        choices = variable_choices(ADLB, subset = c("LBCAT", "PARAM", "AVISIT")),
        selected = c("LBCAT", "PARAM"),
        keep_order = TRUE
      ),
      baseline_var = choices_selected(
        variable_choices(ADLB, subset = "BNRIND"),
        selected = "BNRIND", fixed = TRUE
      ),
      grade = choices_selected(
        choices = variable_choices(ADLB, subset = "ANRIND"),
        selected = "ANRIND",
        fixed = TRUE
      ),
      abnormal = list(low = "LOW", high = "HIGH"),
      exclude_base_abn = FALSE
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsO-VNVaNFEEr8UKRQ+kZc1AD6waHWQSFhhjoA7rSkABa0EOyxULg6IEo6OgCCACIAygAy4TqkMARRcAAeUVD8otTFZeXVAEJ1DU2t7fzU9DoApAB8Uz0lMIKh5OwLJToA8gBy9rYAYrUAvDqyonBRKRkUaxAb92UAagCSlc+209lTp2tglQDCWCcTm2z22AHEFHgdFD+qVKk5qmCXGAbAA-GFgKG4db3ezOHQYqEATShuJ0Nlm3zSmSi1Cg9Dg1F+mzutkYcBC8DIOiwcGIjH4On29IA5lCAvcAgBfAIAKyI2SiAGs4KxRLlEjZkvw4MYoMJSFECPxaKImgqlar1cBoPANXk5ABdVwQCo1Op5YDAKHu6pQp0ut19QY6xLe30hgNBpRoVB1bLpW4lPI6E55HF3HR8IQiURp7MCYRiZMbBpRI0MiBERgwbjpDjk+mM6gF330au1+ukVh2BkibHkvJ23QnSMDQdZ+4sGBRTQsAsEDKKghiKLnETqOD8UsPU7LmRiAvzxi0fsXJcrkt+gqiQT0c6kRe-UpYACy2Mxr7f-3KErkmZ7iUG78uQQpjmA35klOGwAeSHT8BWRChK2Jz7KU1QIoBDz0Kwc4sPmJyXoeojrkyoHbruDzEauhE6CeZ70CIxoHrR7AVAMt73o+z5QgM-ylLYn5QgACq+pQftCvovG8QmonBMH3CBW7gT8fH9AJckFKJ4mSQpQE6KqcCoFENa6owBb4i4ikUth9z0FAG7ZBcJ6Lqxa7KWBVH3Ax54sVeGocf0XEPnAT4Qf02xYGCf6onZDyedubZgJF0XbLFBTGLQLRJScVnkvpDyiswupuQFZGbl55IlDRR4nL5TEXu5gUhiFPEQaUUUxRK8VKeRKnJZ1aUZdVJjZbldiONZe6FdOHY1nWqE6HQoikOw1BECkyXVJsADqn5ZKKGTJQAEs84InT15KtJIgi6lEDnnO0HYFuhmHTbBPQBAEtDGDo7DZOQagaNo1g2EUWaiFkECsKU6DsHGAAkgi0AUSPnIw2j+Eo0pKGA0pOkAA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsO-VNVaNFEEr8UKRQ+kZc1AD6waHWQSFhhjoA7rSkABa0EOyxULg6IEo6OgCCACIAygAy4TqkMARRcAAeUVD8otTFZeXVAEJ1DU2t7fzU9DoApAB8Uz0lMIKh5OwLJToA8gBy9rYAYrUAvDqyonBRKRkUaxAb92UAagCSlc+209lTp2tglQDCWCcTm2z22AHEFHgdFD+qVKk5qmCXGAbAA-GFgKG4db3ezOHQYqEATShuJ0Nlm3zSmSi1Cg9Dg1F+mzutkYcBC8DIOiwcGIjH4On29IA5lCAvcAgBfAIAKyI2SiAGs4KxRLlEjZkvw4MYoMJSFECPxaKImgqlar1cBoPANXk5ABdVwQCo1Op5YDAKHu6pQp0ut19QY6xLe30hgNBpRoVB1bLpW4lPI6E55HF3HR8IQiURp7MCYRiZMbBpRI0MiBERgwbjpDjk+mM6gF330au1+ukVh2BkibHkvJ23QnSMDQdZ+4sGBRTQsAsEDKKghiKLnETqOD8UsPU7LmRiAvzxi0fsXJcrkt+gqiQT0c6kRe-UpYACy2Mxr7f-3KErkmZ7iUG78uQQpjmA35klOGwAeSHT8BWRChK2Jz7KU1QIoBDz0Kwc4sPmJyXoeojrkyoHbruDzEauhE6CeZ70CIxoHrR7AVAMt73o+z5QgM-ylLYn5QgACq+pQftCvovG8QmonBMH3CBW7gT8fH9AJckFKJ4mSQpQE6KqcCoFENa6owBb4i4ikUth9z0FAG7ZBcJ6Lqxa7KWBVH3Ax54sVeGocf0XEPnAT4Qf02xYGCf6onZDyedubZgJF0XbLFBTGLQLRJScVnkvpDyiswupuQFZGbl55IlDRR4nL5TEXu5gUhiFPEQaUUUxRK8VKeRKnJZ1aUZdVJjZbldiONZe6FdOHY1nWqE6HQoikOw1BECkyXVJsADqn5ZKKGTJQAEs84InT15KtJIgi6lEDnnO0HYFuhmHTbBPQBAEtDGDo7DZOQagaNo1g2EUWaiFkECsKU6DsHGAAkgi0AUSPnIw2j+Eo0pKGA0pOkAA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

