% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_utils.R
\name{as_yaml_auto}
\alias{as_yaml_auto}
\title{Parse a Named List to the \code{Rmd} \code{yaml} Header}
\usage{
as_yaml_auto(
  input_list,
  as_header = TRUE,
  convert_logi = TRUE,
  multi_output = FALSE,
  silent = FALSE
)
}
\arguments{
\item{input_list}{\verb{named list} non nested with slots names and their values compatible with \code{Rmd} \code{yaml} header.}

\item{as_header}{\code{logical} optionally wrap with result with the internal \code{md_header()}, default \code{TRUE}.}

\item{convert_logi}{\code{logical} convert a character values to logical,
if they are recognized as quoted \code{yaml} logical values , default \code{TRUE}.}

\item{multi_output}{\code{logical} multi \code{output} slots in the \code{input} argument, default \code{FALSE}.}

\item{silent}{\code{logical} suppress messages and warnings, default \code{FALSE}.}
}
\value{
\code{character} with \code{rmd_yaml_header} class,
result of \code{\link[yaml:as.yaml]{yaml::as.yaml}}, optionally wrapped with internal \code{md_header()}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
parse a named list to the \code{Rmd} \code{yaml} header, so the developer gets automatically tabulated \code{Rmd} \code{yaml} header.
Only a non nested (flat) list will be processed,
where as a nested list is directly processed with the \code{\link[yaml:as.yaml]{yaml::as.yaml}} function.
All \code{Rmd} \code{yaml} header fields from the vector are supported,
\code{c("author", "date", "title", "subtitle", "abstract", "keywords", "subject", "description", "category", "lang")}.
Moreover all \code{output}field types in the \code{rmarkdown} package and their arguments are supported.
}
\examples{
# nested so using yaml::as.yaml directly
as_yaml_auto(
  list(author = "", output = list(pdf_document = list(toc = TRUE)))
)

# auto parsing for a flat list, like shiny input
input <- list(author = "", output = "pdf_document", toc = TRUE, keep_tex = TRUE)
as_yaml_auto(input)

as_yaml_auto(list(author = "", output = "pdf_document", toc = TRUE, keep_tex = "TRUE"))

as_yaml_auto(list(
  author = "", output = "pdf_document", toc = TRUE, keep_tex = TRUE,
  wrong = 2
))

as_yaml_auto(list(author = "", output = "pdf_document", toc = TRUE, keep_tex = 2),
  silent = TRUE
)

input <- list(author = "", output = "pdf_document", toc = TRUE, keep_tex = "True")
as_yaml_auto(input)
as_yaml_auto(input, convert_logi = TRUE, silent = TRUE)
as_yaml_auto(input, silent = TRUE)
as_yaml_auto(input, convert_logi = FALSE, silent = TRUE)

as_yaml_auto(
  list(
    author = "", output = "pdf_document",
    output = "html_document", toc = TRUE, keep_tex = TRUE
  ),
  multi_output = TRUE
)
as_yaml_auto(
  list(
    author = "", output = "pdf_document",
    output = "html_document", toc = "True", keep_tex = TRUE
  ),
  multi_output = TRUE
)
}
