% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_slice.R
\name{get_default_slice_id}
\alias{get_default_slice_id}
\title{Default \code{teal_slice} id}
\usage{
get_default_slice_id(x)
}
\arguments{
\item{x}{(\code{teal_slice} or \code{list})}
}
\value{
(\code{character(1)}) \code{id} for a \code{teal_slice} object.
}
\description{
Create a slice id if none provided.
}
\details{
Function returns a default \code{id} for a \code{teal_slice} object which needs
to be distinct from other \code{teal_slice} objects created for any
\code{FilterStates} object. Returned \code{id} can be treated as a location of
a vector on which \code{FilterState} is built:
\itemize{
\item for a \code{data.frame} \code{id} concatenates \code{dataname} and \code{varname}.
\item for a \code{MultiAssayExperiment} \code{id} concatenates \code{dataname}, \code{varname},
\code{experiment} and \code{arg}, so that one can add \code{teal_slice} for a \code{varname}
which exists in multiple \code{SummarizedExperiment}s or exists in both \code{colData}
and \code{rowData} of given experiment.
For such a vector \code{teal.slice} doesn't allow to activate more than one filters.
In case of \code{teal_slice_expr} \code{id} is mandatory and must be unique.
}
}
\keyword{internal}
