% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterStatesMatrix.R
\docType{class}
\name{MatrixFilterStates}
\alias{MatrixFilterStates}
\title{\code{FilterStates} subclass for matrices}
\description{
Handles filter states in a \code{matrix}.
}
\keyword{internal}
\section{Super class}{
\code{\link[teal.slice:FilterStates]{teal.slice::FilterStates}} -> \code{MatrixFilterStates}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MatrixFilterStates-new}{\code{MatrixFilterStates$new()}}
\item \href{#method-MatrixFilterStates-clone}{\code{MatrixFilterStates$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="clear_filter_states"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-clear_filter_states'><code>teal.slice::FilterStates$clear_filter_states()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="finalize"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-finalize'><code>teal.slice::FilterStates$finalize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="format"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-format'><code>teal.slice::FilterStates$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="get_call"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-get_call'><code>teal.slice::FilterStates$get_call()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="get_filter_state"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-get_filter_state'><code>teal.slice::FilterStates$get_filter_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="print"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-print'><code>teal.slice::FilterStates$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="remove_filter_state"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-remove_filter_state'><code>teal.slice::FilterStates$remove_filter_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="set_filter_state"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-set_filter_state'><code>teal.slice::FilterStates$set_filter_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="srv_active"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-srv_active'><code>teal.slice::FilterStates$srv_active()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="srv_add"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-srv_add'><code>teal.slice::FilterStates$srv_add()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="ui_active"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-ui_active'><code>teal.slice::FilterStates$ui_active()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterStates" data-id="ui_add"><a href='../../teal.slice/html/FilterStates.html#method-FilterStates-ui_add'><code>teal.slice::FilterStates$ui_add()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixFilterStates-new"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixFilterStates-new}{}}}
\subsection{Method \code{new()}}{
Initialize \code{MatrixFilterStates} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixFilterStates$new(
  data,
  data_reactive = function(sid = "") NULL,
  dataname,
  datalabel = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(\code{matrix})
the \code{R} object which \code{subset} function is applied on.}

\item{\code{data_reactive}}{(\verb{function(sid)})
should return a \code{matrix} object or \code{NULL}.
This object is needed for the \code{FilterState} counts being updated on a change in filters.
If function returns \code{NULL} then filtered counts are not shown.
Function has to have \code{sid} argument being a character.}

\item{\code{dataname}}{(\code{character(1)})
name of the data used in the subset expression.
Passed to the function argument attached to this \code{FilterStates}.}

\item{\code{datalabel}}{(\code{character(1)}) optional
text label. Should be a name of experiment.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MatrixFilterStates-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MatrixFilterStates-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MatrixFilterStates$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
