% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_group.R
\name{panel_item}
\alias{panel_item}
\title{Panel item widget}
\usage{
panel_item(title, ..., collapsed = TRUE, input_id = NULL)
}
\arguments{
\item{title}{(\code{character})\cr title of panel}

\item{...}{content of panel}

\item{collapsed}{(\code{logical}) optional,\cr
whether to initially collapse panel}

\item{input_id}{(\code{character}) optional\cr
name of the panel item element. If supplied, this will register a shiny input variable that
indicates whether the panel item is open or collapsed and is accessed with \code{input$input_id}.}
}
\value{
(\code{shiny.tag})
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}\cr
Designed to be grouped using \code{\link{panel_group}} element. Used to handle \code{shiny} inputs in the encoding panel.
}
\examples{

library(shiny)
panel_item(
  title = "Display",
  collapsed = FALSE,
  checkboxGroupInput(
    "check",
    "Tables display",
    choices = LETTERS[1:3],
    selected = LETTERS[1]
  ),
  radioButtons(
    "radio",
    label = "Plot type",
    choices = letters[1:2],
    selected = letters[1]
  )
)

}
