% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validations.R
\name{validate_in}
\alias{validate_in}
\title{Validates that vector includes all expected values}
\usage{
validate_in(x, choices, msg)
}
\arguments{
\item{x}{Vector of values to test.}

\item{choices}{Vector to test against.}

\item{msg}{(\code{character(1)}) Error message to display if some elements of \code{x} are not elements of \code{choices}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
This function is a wrapper for \code{shiny::validate}.
}
\examples{
ui <- fluidPage(
  selectInput(
    "species",
    "Select species",
    choices = c("setosa", "versicolor", "virginica", "unknown species"),
    selected = "setosa",
    multiple = FALSE
  ),
  verbatimTextOutput("summary")
)

server <- function(input, output) {
  output$summary <- renderPrint({
    validate_in(input$species, iris$Species, "Species does not exist.")
    nrow(iris[iris$Species == input$species, ])
  })
}
if (interactive()) {
  shinyApp(ui, server)
}

}
