% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updater.R
\name{Updater}
\alias{Updater}
\title{Updater}
\format{An \code{\link{R6Class}} object.}
\usage{
Updater(token = NULL, base_url = NULL, base_file_url = NULL,
  request_config = NULL, bot = NULL)
}
\arguments{
\item{token}{(Optional). The bot's token given by the @BotFather.}

\item{base_url}{(Optional). Telegram Bot API service URL.}

\item{base_file_url}{(Optional). Telegram Bot API file URL.}

\item{request_config}{(Optional). Additional configuration settings
to be passed to the bot's POST requests. See the \code{config}
parameter from \code{?httr::POST} for further details.

The \code{request_config} settings are very
useful for the advanced users who would like to control the
default timeouts and/or control the proxy used for http communication.}

\item{bot}{(Optional). A pre-initialized \code{Bot} instance.}
}
\description{
Package main class. This class, which employs the class \code{\link{Dispatcher}}, provides a front-end to
class \code{\link{Bot}} to the programmer, so they can focus on coding the bot. Its purpose is to
receive the updates from Telegram and to deliver them to said dispatcher. The
dispatcher supports \code{\link{Handler}} classes for different kinds of data: Updates from Telegram, basic text
commands and even arbitrary types.
}
\details{
\strong{Note:} You \strong{must} supply either a \code{bot} or a \code{token} argument.
}
\section{Methods}{
 \describe{
    \item{\code{\link{start_polling}}}{Starts polling updates from Telegram.}
    \item{\code{\link{stop_polling}}}{Stops the polling.}
}
}

\examples{
\dontrun{
updater <- Updater(token = 'TOKEN')

# In case you want to set a proxy (see ?httr:use_proxy for setting details)
updater <- Updater(token = 'TOKEN', request_config = httr::use_proxy(...))
}
}
\references{
\href{http://core.telegram.org/bots}{Bots: An
    introduction for developers} and
    \href{http://core.telegram.org/bots/api}{Telegram Bot API}
}
