% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{tcata.diff.plot}
\alias{tcata.diff.plot}
\title{TCATA difference plot}
\usage{
tcata.diff.plot(x1 = x1, x2 = NA, n1 = 1, n2 = NA,
attributes = c(), times = c(), lwd = 1,
declutter = NA, get.decluttered = FALSE, emphasis = NA, alpha = 0.05, emphasis.lwd = 3,
main = "", height = 8, width = 12,
xlab = "Time", ylab = "Difference in citation proportion",
line.col = c(), x.increment = 5, legend.cex = 1, save.as = "")
}
\arguments{
\item{x1}{matrix of difference proportions, or of counts if \code{n1} specified. If \code{mat2} specified then proportions or counts apply to first sample. Attributes are in rows, times in columns.}

\item{x2}{matrix of proportions for second sample, or of counts if \code{n2} specified.}

\item{n1}{number of observations for first sample}

\item{n2}{number of observations for second sample}

\item{attributes}{vector of attribute labels for row in \code{x1} (and \code{x2})}

\item{times}{vector of times for columns in \code{x1} (and \code{x2})}

\item{lwd}{Line width}

\item{declutter}{indicator matrix with same dimensions of \code{x1} to suppress output}

\item{get.decluttered}{if \code{TRUE} then calculates the \code{declutter}  matrix from \code{get.mat.diff.sign}}

\item{emphasis}{set to \code{1} to emphasize significant differences}

\item{alpha}{significance level to use for entrywise test of \code{x1} and \code{x2} (if counts)}

\item{emphasis.lwd}{line weight for emphasizing significant differences}

\item{main}{plot title; see \code{\link[graphics]{plot}}}

\item{height}{plot height}

\item{width}{plot width}

\item{xlab}{label for x axis}

\item{ylab}{label for y axis}

\item{line.col}{line color for attribute lines}

\item{x.increment}{increment between time labels on x axis}

\item{legend.cex}{symbol size for legend}

\item{save.as}{Filename to use if file will be saved.}
}
\description{
Plots TCATA difference curves.
}
\examples{
# difference between High and Low ethanol wines (sip 1)
x.diff.raw <- t(syrah[seq(1, 1026, by = 6), -c(1:4)]) -
                t(syrah[seq(3, 1026, by = 6), -c(1:4)])
x.diff.smooth <- get.smooth(x.diff.raw, low.bound = -1, up.bound = 1)
colnames(x.diff.smooth) <- colnames(x.diff.raw) <- times <- 10:180
tcata.diff.plot(x1 = x.diff.smooth, attributes = rownames(x.diff.smooth), times = times, lwd = 2,
                main = "Sip 1 differences: High-ethanol wine - Low-ethanol wine")

# an example based on the syrah data set (truncated for efficiency)
n <- 52
H1 <- t(syrah[seq(1, 126, by = 6), -c(1:4)] * n)
L1 <- t(syrah[seq(3, 126, by = 6), -c(1:4)] * n)
colnames(H1) <- colnames(L1) <- times <- 10:30
tcata.diff.plot(x1 = H1, x2 = L1, n1 = n, n2 = n,
                attributes = rownames(H1), get.decluttered = TRUE, lwd = 2)
}
\references{
Castura, J. C., Antúnez, L., Giménez, A., Ares, G. (2016). Temporal check-all-that-apply (TCATA): A novel temporal sensory method for characterizing products. \emph{Food Quality and Preference}, 47, 79-90. \url{http://dx.doi.org/10.1016/j.foodqual.2015.06.017}
}
