% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_regress.R
\name{tensor_regress}
\alias{tensor_regress}
\title{Generalized Tensor Regression}
\usage{
tensor_regress(
  tsr,
  X_covar1 = NULL,
  X_covar2 = NULL,
  X_covar3 = NULL,
  core_shape,
  Nsim = 20,
  cons = c("non", "vanilla", "penalty"),
  lambda = 0.1,
  alpha = 1,
  solver = "CG",
  dist = c("binary", "poisson", "normal")
)
}
\arguments{
\item{tsr}{response tensor with 3 modes}

\item{X_covar1}{covariate on first mode}

\item{X_covar2}{covariate on second mode}

\item{X_covar3}{covariate on third mode}

\item{core_shape}{the Tucker rank of the regression coefficients}

\item{Nsim}{max number of iterations if update does not convergence}

\item{cons}{the constraint method, "non" for without constraint, "vanilla" for global scale down at each iteration,

                   "penalty" for adding log-barrier penalty to object function}

\item{lambda}{penalty coefficient for "penalty" constraint}

\item{alpha}{max norm constraint on linear predictor}

\item{solver}{solver for solving object function when using "penalty" constraint, see "details"}

\item{dist}{distribution of the response tensor, see "details"}
}
\value{
a list containing the following:

                 \code{W} {a list of orthogonal coefficient matrices - one for each mode, with the number of columns given by \code{core_shape}}

                 \code{G}  {an array, core tensor with the size specified by \code{core_shape}}

                 \code{C_ts}  {an array, coefficient tensor, Tucker product of \code{G},\code{A},\code{B},\code{C}}

                 \code{U} {linear predictor,i.e. Tucker product of \code{C_ts},\code{X_covar1},\code{X_covar2},\code{X_covar3}}

                 \code{lglk} {a vector containing loglikelihood at convergence}

                 \code{sigma} {a scalar, estimated error variance (for Gaussian tensor) or dispersion parameter (for Bernoulli and Poisson tensors)}

                 \code{violate} {a vector listing whether each iteration violates the max norm constraint on the linear predictor, \code{1} indicates violation}
}
\description{
Tensor-response regression given covariates on multiple modes. Main function in the package. The function takes a response tensor, multiple covariate matrices, and a desired Tucker rank as input. The output is a constrained
MLE for the coefficient tensor.
}
\details{
Constraint \code{penalty} adds log-barrier regularizer to
           general object function (negative log-likelihood). The main function uses solver in function "optim" to
           solve the objective function. The "solver" passes to the argument "method" in function "optim".

           \code{dist} specifies three distributions of response tensor: binary, poisson and normal distribution.
}
\examples{
seed = 34
dist = 'binary'
data=sim_data(seed, whole_shape = c(20,20,20), core_shape=c(3,3,3),
p=c(5,5,5),dist=dist, dup=5, signal=4)
re = tensor_regress(data$tsr[[1]],data$X_covar1,data$X_covar2,data$X_covar3,
core_shape=c(3,3,3),Nsim=10, cons = 'non', dist = dist)
}
